/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo.dependencies;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.JarData;
import org.apache.maven.shared.jar.classes.JarClassesAnalysis;

public class Dependencies {
    private final MavenProject project;
    private final DependencyNode dependencyTreeNode;
    private final JarClassesAnalysis classesAnalyzer;
    private List projectDependencies;
    private List projectTransitiveDependencies;
    private List allDependencies;
    private Map dependenciesByScope;
    private Map transitiveDependenciesByScope;
    private Map dependencyDetails;

    public Dependencies(MavenProject project, DependencyNode dependencyTreeNode, JarClassesAnalysis classesAnalyzer) {
        this.project = project;
        this.dependencyTreeNode = dependencyTreeNode;
        this.classesAnalyzer = classesAnalyzer;
        HashMap<String, Artifact> projectMap = new HashMap<String, Artifact>();
        Iterator it = project.getArtifacts().iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            projectMap.put(ArtifactUtils.versionlessKey((Artifact)artifact), artifact);
        }
        this.mapArtifactFiles(dependencyTreeNode, projectMap);
    }

    public MavenProject getProject() {
        return this.project;
    }

    public boolean hasDependencies() {
        return this.getProjectDependencies() != null && !this.getProjectDependencies().isEmpty();
    }

    public List getProjectDependencies() {
        if (this.projectDependencies != null) {
            return this.projectDependencies;
        }
        this.projectDependencies = new ArrayList();
        Iterator i = this.dependencyTreeNode.getChildren().iterator();
        while (i.hasNext()) {
            DependencyNode dependencyNode = (DependencyNode)i.next();
            this.projectDependencies.add(dependencyNode.getArtifact());
        }
        return this.projectDependencies;
    }

    public List getTransitiveDependencies() {
        if (this.projectTransitiveDependencies != null) {
            return this.projectTransitiveDependencies;
        }
        this.projectTransitiveDependencies = new ArrayList(this.getAllDependencies());
        this.projectTransitiveDependencies.removeAll(this.getProjectDependencies());
        return this.projectTransitiveDependencies;
    }

    public List getAllDependencies() {
        if (this.allDependencies != null) {
            return this.allDependencies;
        }
        this.allDependencies = new ArrayList();
        Iterator i = this.dependencyTreeNode.getChildren().iterator();
        while (i.hasNext()) {
            DependencyNode dependencyNode = (DependencyNode)i.next();
            if (dependencyNode.getState() != 0 || dependencyNode.getArtifact().getGroupId().equals(this.project.getGroupId()) && dependencyNode.getArtifact().getArtifactId().equals(this.project.getArtifactId()) && dependencyNode.getArtifact().getVersion().equals(this.project.getVersion())) continue;
            if (!this.allDependencies.contains(dependencyNode.getArtifact())) {
                this.allDependencies.add(dependencyNode.getArtifact());
            }
            this.getAllDependencies(dependencyNode);
        }
        return this.allDependencies;
    }

    public Map getDependenciesByScope(boolean isTransitively) {
        if (isTransitively) {
            if (this.transitiveDependenciesByScope != null) {
                return this.transitiveDependenciesByScope;
            }
            this.transitiveDependenciesByScope = new HashMap();
            Iterator i = this.getTransitiveDependencies().iterator();
            while (i.hasNext()) {
                Artifact artifact = (Artifact)i.next();
                ArrayList<Artifact> multiValue = (ArrayList<Artifact>)this.transitiveDependenciesByScope.get(artifact.getScope());
                if (multiValue == null) {
                    multiValue = new ArrayList<Artifact>();
                }
                if (!multiValue.contains(artifact)) {
                    multiValue.add(artifact);
                }
                this.transitiveDependenciesByScope.put(artifact.getScope(), multiValue);
            }
            return this.transitiveDependenciesByScope;
        }
        if (this.dependenciesByScope != null) {
            return this.dependenciesByScope;
        }
        this.dependenciesByScope = new HashMap();
        Iterator i = this.getProjectDependencies().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            ArrayList<Artifact> multiValue = (ArrayList<Artifact>)this.dependenciesByScope.get(artifact.getScope());
            if (multiValue == null) {
                multiValue = new ArrayList<Artifact>();
            }
            if (!multiValue.contains(artifact)) {
                multiValue.add(artifact);
            }
            this.dependenciesByScope.put(artifact.getScope(), multiValue);
        }
        return this.dependenciesByScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarData getJarDependencyDetails(Artifact artifact) throws IOException {
        if (this.dependencyDetails == null) {
            this.dependencyDetails = new HashMap();
        }
        JarData old = (JarData)this.dependencyDetails.get(artifact.getId());
        if (this.dependencyDetails.get(artifact.getId()) != null) {
            return old;
        }
        JarAnalyzer jarAnalyzer = new JarAnalyzer(artifact.getFile());
        try {
            this.classesAnalyzer.analyze(jarAnalyzer);
        }
        finally {
            jarAnalyzer.closeQuietly();
        }
        this.dependencyDetails.put(artifact.getId(), jarAnalyzer.getJarData());
        return jarAnalyzer.getJarData();
    }

    private void mapArtifactFiles(DependencyNode node, Map projectMap) {
        List childs = node.getChildren();
        if (childs == null || childs.isEmpty()) {
            return;
        }
        Iterator it = childs.iterator();
        while (it.hasNext()) {
            DependencyNode anode = (DependencyNode)it.next();
            String key = ArtifactUtils.versionlessKey((Artifact)anode.getArtifact());
            Artifact projartifact = (Artifact)projectMap.get(key);
            if (projartifact != null) {
                anode = new DependencyNode(ArtifactUtils.copyArtifact((Artifact)projartifact));
                anode.getArtifact().setFile(projartifact.getFile());
            }
            this.mapArtifactFiles(anode, projectMap);
        }
    }

    private void getAllDependencies(DependencyNode dependencyNode) {
        if (dependencyNode == null || dependencyNode.getChildren() == null) {
            if (!this.allDependencies.contains(dependencyNode.getArtifact())) {
                this.allDependencies.add(dependencyNode.getArtifact());
            }
            return;
        }
        Iterator i = dependencyNode.getChildren().iterator();
        while (i.hasNext()) {
            DependencyNode subdependencyNode = (DependencyNode)i.next();
            if (subdependencyNode.getState() != 0 || subdependencyNode.getArtifact().getGroupId().equals(this.project.getGroupId()) && subdependencyNode.getArtifact().getArtifactId().equals(this.project.getArtifactId()) && subdependencyNode.getArtifact().getVersion().equals(this.project.getVersion())) continue;
            if (!this.allDependencies.contains(subdependencyNode.getArtifact())) {
                this.allDependencies.add(subdependencyNode.getArtifact());
            }
            this.getAllDependencies(subdependencyNode);
        }
    }
}

