/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.gpg;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.deploy.DeployFileMojo;
import org.apache.maven.plugin.gpg.AscArtifactMetadata;
import org.apache.maven.plugin.gpg.GpgSigner;
import org.apache.maven.settings.Settings;

public class SignAndDeployFileMojo
extends DeployFileMojo {
    private String passphrase;
    private String keyname;
    private boolean useAgent;
    private File ascDirectory;
    protected Settings settings;
    private ArtifactHandlerManager artifactHandlerManager;
    private ArtifactDeployer deployer;
    private ArtifactRepository localRepository;
    private String groupId;
    private String artifactId;
    private String version;
    private String packaging;
    private String description;
    private File file;
    private String repositoryId;
    private String repositoryLayout;
    private Map repositoryLayouts;
    private String url;
    private ArtifactFactory artifactFactory;
    private ArtifactRepositoryFactory repositoryFactory;
    private File pomFile;
    private boolean generatePom;
    private String classifier;
    private boolean uniqueVersion;
    private final GpgSigner signer = new GpgSigner();
    static /* synthetic */ Class class$org$apache$maven$plugin$deploy$DeployFileMojo;

    public void execute() throws MojoExecutionException {
        DefaultArtifactHandler handler = new DefaultArtifactHandler("asc");
        HashMap<String, DefaultArtifactHandler> map = new HashMap<String, DefaultArtifactHandler>();
        map.put("asc", handler);
        this.artifactHandlerManager.addHandlers(map);
        this.copyToParent();
        ArtifactDeployer deployer = this.getDeployer();
        this.signer.setInteractive(this.settings.isInteractiveMode());
        this.signer.setKeyName(this.keyname);
        this.signer.setUseAgent(this.useAgent);
        this.signer.setOutputDirectory(this.ascDirectory);
        this.signer.setBaseDirectory(new File("foo").getAbsoluteFile().getParentFile().getAbsoluteFile());
        this.setDeployer(new SignedArtifactDeployer(deployer, this.passphrase));
        super.execute();
    }

    private void copyToParent() throws MojoExecutionException {
        this.setDeployer(this.deployer);
        this.setLocalRepository(this.localRepository);
        this.setDeployFileMojoField("groupId", this.groupId);
        this.setDeployFileMojoField("artifactId", this.artifactId);
        this.setDeployFileMojoField("version", this.version);
        this.setDeployFileMojoField("packaging", this.packaging);
        this.setDeployFileMojoField("description", this.description);
        this.setDeployFileMojoField("file", this.file);
        this.setDeployFileMojoField("repositoryId", this.repositoryId);
        this.setDeployFileMojoField("repositoryLayout", this.repositoryLayout);
        this.setDeployFileMojoField("repositoryLayouts", this.repositoryLayouts);
        this.setDeployFileMojoField("url", this.url);
        this.setDeployFileMojoField("artifactFactory", this.artifactFactory);
        this.setDeployFileMojoField("repositoryFactory", this.repositoryFactory);
        this.setDeployFileMojoField("pomFile", this.pomFile);
        this.setDeployFileMojoField("generatePom", this.generatePom);
        this.setDeployFileMojoField("classifier", this.classifier);
        this.setDeployFileMojoField("uniqueVersion", this.uniqueVersion);
    }

    private void setDeployFileMojoField(String name, Object value) throws MojoExecutionException {
        try {
            Field f = (class$org$apache$maven$plugin$deploy$DeployFileMojo == null ? (class$org$apache$maven$plugin$deploy$DeployFileMojo = SignAndDeployFileMojo.class$("org.apache.maven.plugin.deploy.DeployFileMojo")) : class$org$apache$maven$plugin$deploy$DeployFileMojo).getDeclaredField(name);
            ((AccessibleObject)f).setAccessible(true);
            f.set((Object)this, value);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not set field " + name, e);
        }
    }

    public void setDeployer(ArtifactDeployer deployer) {
        this.deployer = deployer;
        super.setDeployer(deployer);
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
        super.setLocalRepository(localRepository);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SignedArtifactDeployer
    implements ArtifactDeployer {
        ArtifactDeployer deployer;
        String pass;

        public SignedArtifactDeployer(ArtifactDeployer dep, String passphrase) throws MojoExecutionException {
            this.deployer = dep;
            this.pass = passphrase;
            if (!SignAndDeployFileMojo.this.useAgent && null == this.pass) {
                if (!SignAndDeployFileMojo.this.settings.isInteractiveMode()) {
                    throw new MojoExecutionException("Cannot obtain passphrase in batch mode");
                }
                try {
                    this.pass = SignAndDeployFileMojo.this.signer.getPassphrase(null);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Exception reading password", (Exception)e);
                }
            }
        }

        public void deploy(File source, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
            try {
                File fileSig = SignAndDeployFileMojo.this.signer.generateSignatureForArtifact(source, this.pass);
                AscArtifactMetadata metadata = new AscArtifactMetadata(artifact, fileSig, false);
                artifact.addMetadata((ArtifactMetadata)metadata);
                if (!SignAndDeployFileMojo.this.generatePom && SignAndDeployFileMojo.this.pomFile != null) {
                    fileSig = SignAndDeployFileMojo.this.signer.generateSignatureForArtifact(SignAndDeployFileMojo.this.pomFile, this.pass);
                    metadata = new AscArtifactMetadata(artifact, fileSig, true);
                    artifact.addMetadata((ArtifactMetadata)metadata);
                }
                this.deployer.deploy(source, artifact, deploymentRepository, localRepository);
            }
            catch (MojoExecutionException e) {
                throw new ArtifactDeploymentException(e.getMessage(), (Throwable)e);
            }
        }

        public void deploy(String basedir, String finalName, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
            String extension = artifact.getArtifactHandler().getExtension();
            File source = new File(basedir, finalName + "." + extension);
            this.deploy(source, artifact, deploymentRepository, localRepository);
        }
    }
}

