/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.failsafe.xmlsummary;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBException;
import org.apache.maven.plugin.failsafe.xmlsummary.ErrorType;
import org.apache.maven.plugin.failsafe.xmlsummary.FailsafeSummary;
import org.apache.maven.plugin.failsafe.xmlsummary.JAXB;
import org.apache.maven.surefire.suite.RunResult;

public final class FailsafeSummaryXmlUtils {
    public static final Charset UTF8 = Charset.forName("UTF-8");

    private FailsafeSummaryXmlUtils() {
        throw new IllegalStateException("No instantiable constructor.");
    }

    public static RunResult toRunResult(File failsafeSummaryXml) throws JAXBException {
        FailsafeSummary failsafeSummary = JAXB.unmarshal(failsafeSummaryXml, FailsafeSummary.class);
        return new RunResult(failsafeSummary.getCompleted(), failsafeSummary.getErrors(), failsafeSummary.getFailures(), failsafeSummary.getSkipped(), failsafeSummary.getFailureMessage(), failsafeSummary.isTimeout());
    }

    public static void fromRunResultToFile(RunResult fromRunResult, File toFailsafeSummaryXml) throws JAXBException, IOException {
        FailsafeSummaryXmlUtils.fromRunResultToFile(fromRunResult, toFailsafeSummaryXml, UTF8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fromRunResultToFile(RunResult fromRunResult, File toFailsafeSummaryXml, Charset encoding) throws JAXBException, IOException {
        FailsafeSummary summary = new FailsafeSummary();
        summary.setCompleted(fromRunResult.getCompletedCount());
        summary.setFailureMessage(fromRunResult.getFailure());
        summary.setErrors(fromRunResult.getErrors());
        summary.setFailures(fromRunResult.getFailures());
        summary.setSkipped(fromRunResult.getSkipped());
        summary.setTimeout(fromRunResult.isTimeout());
        summary.setResult(ErrorType.fromValue(fromRunResult.getFailsafeCode()));
        String unmarshalled = JAXB.marshal(summary, encoding);
        OutputStreamWriter os = new OutputStreamWriter((OutputStream)new FileOutputStream(toFailsafeSummaryXml), encoding);
        try {
            os.write(unmarshalled);
            os.flush();
        }
        finally {
            os.close();
        }
    }

    public static void writeSummary(RunResult mergedSummary, File mergedSummaryFile, boolean inProgress, Charset encoding) throws IOException, JAXBException {
        if (!mergedSummaryFile.getParentFile().isDirectory()) {
            mergedSummaryFile.getParentFile().mkdirs();
        }
        if (mergedSummaryFile.exists() && inProgress) {
            RunResult runResult = FailsafeSummaryXmlUtils.toRunResult(mergedSummaryFile);
            mergedSummary = mergedSummary.aggregate(runResult);
        }
        FailsafeSummaryXmlUtils.fromRunResultToFile(mergedSummary, mergedSummaryFile, encoding);
    }
}

