/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.repository.internal.MavenMetadata;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.metadata.Metadata;

final class RemoteSnapshotMetadata
extends MavenMetadata {
    private static final String SNAPSHOT = "SNAPSHOT";
    private final Collection<Artifact> artifacts = new ArrayList<Artifact>();
    private final Map<String, SnapshotVersion> versions = new LinkedHashMap<String, SnapshotVersion>();

    public RemoteSnapshotMetadata(Artifact artifact) {
        super(RemoteSnapshotMetadata.createMetadata(artifact), null);
    }

    private RemoteSnapshotMetadata(Metadata metadata, File file) {
        super(metadata, file);
    }

    private static Metadata createMetadata(Artifact artifact) {
        Metadata metadata = new Metadata();
        metadata.setModelVersion("1.1.0");
        metadata.setGroupId(artifact.getGroupId());
        metadata.setArtifactId(artifact.getArtifactId());
        metadata.setVersion(artifact.getBaseVersion());
        return metadata;
    }

    public void bind(Artifact artifact) {
        this.artifacts.add(artifact);
    }

    public MavenMetadata setFile(File file) {
        return new RemoteSnapshotMetadata(this.metadata, file);
    }

    public Object getKey() {
        return this.getGroupId() + ':' + this.getArtifactId() + ':' + this.getVersion();
    }

    public static Object getKey(Artifact artifact) {
        return artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getBaseVersion();
    }

    public String getExpandedVersion(Artifact artifact) {
        return this.versions.get(artifact.getClassifier()).getVersion();
    }

    protected void merge(Metadata recessive) {
        Snapshot snapshot;
        String lastUpdated = "";
        if (this.metadata.getVersioning() == null) {
            SimpleDateFormat utcDateFormatter = new SimpleDateFormat("yyyyMMdd.HHmmss");
            utcDateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            snapshot = new Snapshot();
            snapshot.setBuildNumber(RemoteSnapshotMetadata.getBuildNumber(recessive) + 1);
            snapshot.setTimestamp(utcDateFormatter.format(new Date()));
            Versioning versioning = new Versioning();
            versioning.setSnapshot(snapshot);
            versioning.setLastUpdated(snapshot.getTimestamp().replace(".", ""));
            lastUpdated = versioning.getLastUpdated();
            this.metadata.setVersioning(versioning);
        } else {
            snapshot = this.metadata.getVersioning().getSnapshot();
            lastUpdated = this.metadata.getVersioning().getLastUpdated();
        }
        for (Artifact artifact : this.artifacts) {
            String version = artifact.getVersion();
            if (version.endsWith(SNAPSHOT)) {
                String qualifier = snapshot.getTimestamp() + "-" + snapshot.getBuildNumber();
                version = version.substring(0, version.length() - SNAPSHOT.length()) + qualifier;
            }
            SnapshotVersion sv = new SnapshotVersion();
            sv.setClassifier(artifact.getClassifier());
            sv.setVersion(version);
            sv.setUpdated(lastUpdated);
            this.versions.put(sv.getClassifier(), sv);
        }
        this.artifacts.clear();
        Versioning versioning = recessive.getVersioning();
        if (versioning != null) {
            for (SnapshotVersion sv : versioning.getSnapshotVersions()) {
                if (this.versions.containsKey(sv.getClassifier())) continue;
                this.versions.put(sv.getClassifier(), sv);
            }
        }
        this.metadata.getVersioning().setSnapshotVersions(new ArrayList<SnapshotVersion>(this.versions.values()));
    }

    private static int getBuildNumber(Metadata metadata) {
        Snapshot snapshot;
        int number = 0;
        Versioning versioning = metadata.getVersioning();
        if (versioning != null && (snapshot = versioning.getSnapshot()) != null && snapshot.getBuildNumber() > 0) {
            number = snapshot.getBuildNumber();
        }
        return number;
    }

    public String getGroupId() {
        return this.metadata.getGroupId();
    }

    public String getArtifactId() {
        return this.metadata.getArtifactId();
    }

    public String getVersion() {
        return this.metadata.getVersion();
    }

    public Metadata.Nature getNature() {
        return Metadata.Nature.SNAPSHOT;
    }
}

