/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.linkcheck;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;

class LinkMatcher {
    private static final Pattern MATCH_PATTERN = Pattern.compile("<(?>link|a|img|script)[^>]*?(?>href|src)\\s*?=\\s*?[\\\"'](.*?)[\\\"'][^>]*?", 2);
    private static final Set LINK_LIST = new TreeSet();

    private LinkMatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toString(File file, String encoding) throws IOException {
        String content;
        Reader reader = null;
        try {
            reader = ReaderFactory.newReader((File)file, (String)encoding);
            content = IOUtil.toString((Reader)reader);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return content.replaceAll("(?s)<!--.*?-->", "");
    }

    static Set match(File file, String encoding) throws IOException {
        LINK_LIST.clear();
        Matcher m = MATCH_PATTERN.matcher(LinkMatcher.toString(file, encoding));
        while (m.find()) {
            String link = m.group(1).trim();
            if (link.length() < 1 || link.toLowerCase(Locale.ENGLISH).indexOf("javascript") != -1) continue;
            LINK_LIST.add(link);
        }
        return LINK_LIST;
    }
}

