/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geometry.shape;

@Deprecated
public class DistanceApproximation {
    private double m_testLat;
    private double m_testLng;
    private double m_mpd;
    private static final double[] m_milesPerLngDeg = new double[]{69.17097473144531, 69.16043853759766, 69.12883758544922, 69.07617950439453, 69.00247192382812, 68.90775299072266, 68.79203796386719, 68.6553726196289, 68.49779510498047, 68.31934356689453, 68.12008666992188, 67.90007781982422, 67.65938568115234, 67.39808654785156, 67.11625671386719, 66.81397247314453, 66.49134826660156, 66.1484603881836, 65.78543090820312, 65.40235137939453, 64.99935913085938, 64.5765609741211, 64.13409423828125, 63.672096252441406, 63.190696716308594, 62.6900520324707, 62.17031f, 61.63163f, 61.07417678833008, 60.49811935424805, 59.90363311767578, 59.290897369384766, 58.66010665893555, 58.011444091796875, 57.34511184692383, 56.66130828857422, 55.96025085449219, 55.24214553833008, 54.50720977783203, 53.75567626953125, 52.987762451171875, 52.203712463378906, 51.40376281738281, 50.58815002441406, 49.75712966918945, 48.91095733642578, 48.04988098144531, 47.17417f, 46.28409194946289, 45.379913330078125, 44.4619140625, 43.530372619628906, 42.5855712890625, 41.6277961730957, 40.65734100341797, 39.674503326416016, 38.67958068847656, 37.67287826538086, 36.65469741821289, 35.6253547668457, 34.58515930175781, 33.534427642822266, 32.47348403930664, 31.40265f, 30.322248458862305, 29.23261260986328, 28.13407325744629, 27.026962280273438, 25.91162109375, 24.788387298583984, 23.657602310180664, 22.519611358642578, 21.3747615814209, 20.2234f, 19.065881729125977, 17.90255355834961, 16.733774185180664, 15.559897422790527, 14.38128f, 13.198283195495605, 12.011265754699707, 10.82059097290039, 9.626619338989258, 8.429716110229492, 7.230245113372803, 6.028572082519531, 4.825061798095703, 3.620083f, 2.414001941680908, 1.207185f, 1.0};
    public static final double MILES_PER_LATITUDE = 69.17097473144531;
    public static final double KILOMETERS_PER_MILE = (double)1.609347f;

    public void setTestPoint(double lat, double lng) {
        this.m_testLat = lat;
        this.m_testLng = lng;
        this.m_mpd = m_milesPerLngDeg[(int)(Math.abs(lat) + 0.5)];
    }

    public double getDistanceSq(double lat, double lng) {
        double latMiles = (lat - this.m_testLat) * 69.17097473144531;
        double lngMiles = (lng - this.m_testLng) * this.m_mpd;
        return latMiles * latMiles + lngMiles * lngMiles;
    }

    public double getDistanceSq(double lat1, double lng1, double lat2, double lng2) {
        double v1x = lng2 - lng1;
        double v2x = this.m_testLng - lng1;
        double v1y = lat2 - lat1;
        double v2y = this.m_testLat - lat1;
        double dot = v1x * v2x + v1y * v2y;
        if (dot <= 0.0) {
            return this.getDistanceSq(lat1, lng1);
        }
        double c = dot / (v1x * v1x + v1y * v1y);
        if (c >= 1.0) {
            return this.getDistanceSq(lat2, lng2);
        }
        return this.getDistanceSq(lat1 + v1y * c, lng1 + v1x * c);
    }

    public static double getMilesPerLngDeg(double lat) {
        return Math.abs(lat) <= 90.0 ? m_milesPerLngDeg[(int)(Math.abs(lat) + 0.5)] : 69.17097473144531;
    }

    public static double getMilesPerLatDeg() {
        return 69.17097473144531;
    }
}

