/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import org.apache.lucene.facet.search.Aggregator;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;

public abstract class FacetRequest {
    public static final int DEFAULT_DEPTH = 1;
    public static final ResultMode DEFAULT_RESULT_MODE = ResultMode.PER_NODE_IN_TREE;
    public final CategoryPath categoryPath;
    public final int numResults;
    private int numLabel;
    private int depth;
    private SortOrder sortOrder;
    private final int hashCode;
    private ResultMode resultMode = DEFAULT_RESULT_MODE;

    public FacetRequest(CategoryPath path, int numResults) {
        if (numResults <= 0) {
            throw new IllegalArgumentException("num results must be a positive (>0) number: " + numResults);
        }
        if (path == null) {
            throw new IllegalArgumentException("category path cannot be null!");
        }
        this.categoryPath = path;
        this.numResults = numResults;
        this.numLabel = numResults;
        this.depth = 1;
        this.sortOrder = SortOrder.DESCENDING;
        this.hashCode = this.categoryPath.hashCode() ^ this.numResults;
    }

    public Aggregator createAggregator(boolean useComplements, FacetArrays arrays, TaxonomyReader taxonomy) throws IOException {
        throw new UnsupportedOperationException("this FacetRequest does not support this type of Aggregator anymore; you should override FacetsAccumulator to return the proper FacetsAggregator");
    }

    public boolean equals(Object o) {
        if (o instanceof FacetRequest) {
            FacetRequest that = (FacetRequest)o;
            return that.hashCode == this.hashCode && that.categoryPath.equals(this.categoryPath) && that.numResults == this.numResults && that.depth == this.depth && that.resultMode == this.resultMode && that.numLabel == this.numLabel;
        }
        return false;
    }

    public final int getDepth() {
        return this.depth;
    }

    public abstract FacetArraysSource getFacetArraysSource();

    public final int getNumLabel() {
        return this.numLabel;
    }

    public final ResultMode getResultMode() {
        return this.resultMode;
    }

    public final SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public abstract double getValueOf(FacetArrays var1, int var2);

    public int hashCode() {
        return this.hashCode;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setNumLabel(int numLabel) {
        this.numLabel = numLabel;
    }

    public void setResultMode(ResultMode resultMode) {
        this.resultMode = resultMode;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String toString() {
        return this.categoryPath.toString() + " nRes=" + this.numResults + " nLbl=" + this.numLabel;
    }

    public static enum SortOrder {
        ASCENDING,
        DESCENDING;

    }

    public static enum FacetArraysSource {
        INT,
        FLOAT,
        BOTH;

    }

    public static enum ResultMode {
        PER_NODE_IN_TREE,
        GLOBAL_FLAT;

    }
}

