/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import org.apache.lucene.facet.search.Aggregator;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.util.IntsRef;

public class CountingAggregator
implements Aggregator {
    protected int[] counterArray;

    public CountingAggregator(int[] counterArray) {
        this.counterArray = counterArray;
    }

    @Override
    public void aggregate(int docID, float score, IntsRef ordinals) throws IOException {
        for (int i = 0; i < ordinals.length; ++i) {
            int n = ordinals.ints[i];
            this.counterArray[n] = this.counterArray[n] + 1;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CountingAggregator that = (CountingAggregator)obj;
        return that.counterArray == this.counterArray;
    }

    public int hashCode() {
        return this.counterArray == null ? 0 : this.counterArray.hashCode();
    }

    @Override
    public boolean setNextReader(AtomicReaderContext context) throws IOException {
        return true;
    }
}

