/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.codecs.facet42;

import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.lucene42.Lucene42Codec;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.params.FacetIndexingParams;

public class Facet42Codec
extends Lucene42Codec {
    private final Set<String> facetFields;
    private final DocValuesFormat facetsDVFormat = DocValuesFormat.forName((String)"Facet42");
    private final DocValuesFormat lucene42DVFormat = DocValuesFormat.forName((String)"Lucene42");

    public Facet42Codec() {
        this(FacetIndexingParams.DEFAULT);
    }

    public Facet42Codec(FacetIndexingParams fip) {
        if (fip.getPartitionSize() != Integer.MAX_VALUE) {
            throw new IllegalArgumentException("this Codec does not support partitions");
        }
        this.facetFields = new HashSet<String>();
        for (CategoryListParams clp : fip.getAllCategoryListParams()) {
            this.facetFields.add(clp.field);
        }
    }

    public DocValuesFormat getDocValuesFormatForField(String field) {
        if (this.facetFields.contains(field)) {
            return this.facetsDVFormat;
        }
        return this.lucene42DVFormat;
    }
}

