/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;

public class ChangeLog {
    private final Map addedStates = new LinkedMap();
    private final Map modifiedStates = new LinkedMap();
    private final Map deletedStates = new LinkedMap();
    private final Map modifiedRefs = new LinkedMap();

    public boolean hasUpdates() {
        return !this.addedStates.isEmpty() || !this.modifiedStates.isEmpty() || !this.deletedStates.isEmpty() || !this.modifiedRefs.isEmpty();
    }

    public void added(ItemState state) {
        this.addedStates.put(state.getId(), state);
    }

    public void modified(ItemState state) {
        if (!this.addedStates.containsKey(state.getId())) {
            state.disconnect();
            this.modifiedStates.put(state.getId(), state);
        }
    }

    public void deleted(ItemState state) {
        if (this.addedStates.remove(state.getId()) == null) {
            state.disconnect();
            this.modifiedStates.remove(state.getId());
            this.deletedStates.put(state.getId(), state);
        }
    }

    public void modified(NodeReferences refs) {
        this.modifiedRefs.put(refs.getId(), refs);
    }

    public ItemState get(ItemId id) throws NoSuchItemStateException {
        ItemState state = (ItemState)this.addedStates.get(id);
        if (state == null && (state = (ItemState)this.modifiedStates.get(id)) == null && this.deletedStates.containsKey(id)) {
            throw new NoSuchItemStateException("State has been marked destroyed: " + id);
        }
        return state;
    }

    public boolean has(ItemId id) {
        return this.addedStates.containsKey(id) || this.modifiedStates.containsKey(id);
    }

    public boolean deleted(ItemId id) {
        return this.deletedStates.containsKey(id);
    }

    public boolean isModified(ItemId id) {
        return this.modifiedStates.containsKey(id);
    }

    public NodeReferences get(NodeReferencesId id) {
        return (NodeReferences)this.modifiedRefs.get(id);
    }

    public Iterator addedStates() {
        return this.addedStates.values().iterator();
    }

    public Iterator modifiedStates() {
        return this.modifiedStates.values().iterator();
    }

    public Iterator deletedStates() {
        return this.deletedStates.values().iterator();
    }

    public Iterator modifiedRefs() {
        return this.modifiedRefs.values().iterator();
    }

    public void merge(ChangeLog other) {
        ItemState state;
        Iterator iter = other.deletedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            if (this.addedStates.remove(state.getId()) == null) {
                this.deletedStates.put(state.getId(), state);
            }
            this.modifiedStates.remove(state.getId());
        }
        iter = other.modifiedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            if (!this.addedStates.containsKey(state.getId())) {
                this.modifiedStates.put(state.getId(), state);
                continue;
            }
            state.setStatus(4);
            this.addedStates.put(state.getId(), state);
        }
        iter = other.addedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            ItemState deletedState = (ItemState)this.deletedStates.remove(state.getId());
            if (deletedState != null) {
                state.setStatus(deletedState.getStatus());
                state.setModCount(deletedState.getModCount());
                this.modifiedStates.put(state.getId(), state);
                continue;
            }
            this.addedStates.put(state.getId(), state);
        }
        this.modifiedRefs.putAll(other.modifiedRefs);
    }

    public void push() {
        Iterator iter = this.modifiedStates();
        while (iter.hasNext()) {
            ((ItemState)iter.next()).push();
        }
        iter = this.deletedStates();
        while (iter.hasNext()) {
            ((ItemState)iter.next()).push();
        }
        iter = this.addedStates();
        while (iter.hasNext()) {
            ((ItemState)iter.next()).push();
        }
    }

    public void persisted() {
        ItemState state;
        Iterator iter = this.modifiedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            state.setStatus(1);
            state.notifyStateUpdated();
        }
        iter = this.deletedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            state.setStatus(3);
            state.notifyStateDestroyed();
            state.discard();
        }
        iter = this.addedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            state.setStatus(1);
            state.notifyStateCreated();
        }
    }

    public void reset() {
        this.addedStates.clear();
        this.modifiedStates.clear();
        this.deletedStates.clear();
        this.modifiedRefs.clear();
    }

    public void disconnect() {
        Iterator iter = this.modifiedStates();
        while (iter.hasNext()) {
            ((ItemState)iter.next()).disconnect();
        }
        iter = this.deletedStates();
        while (iter.hasNext()) {
            ((ItemState)iter.next()).disconnect();
        }
        iter = this.addedStates();
        while (iter.hasNext()) {
            ((ItemState)iter.next()).disconnect();
        }
    }

    public void undo(ItemStateManager parent) {
        ItemState state;
        Iterator iter = this.modifiedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            try {
                state.connect(parent.getItemState(state.getId()));
                state.pull();
            }
            catch (ItemStateException e) {
                state.discard();
            }
        }
        iter = this.deletedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            try {
                state.connect(parent.getItemState(state.getId()));
                state.pull();
            }
            catch (ItemStateException e) {
                state.discard();
            }
        }
        iter = this.addedStates();
        while (iter.hasNext()) {
            ((ItemState)iter.next()).discard();
        }
        this.reset();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        buf.append("#addedStates=").append(this.addedStates.size());
        buf.append(", #modifiedStates=").append(this.modifiedStates.size());
        buf.append(", #deletedStates=").append(this.deletedStates.size());
        buf.append(", #modifiedRefs=").append(this.modifiedRefs.size());
        buf.append("}");
        return buf.toString();
    }
}

