/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.principal;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.principal.NoSuchPrincipalException;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.core.security.principal.AbstractPrincipalIterator;
import org.apache.jackrabbit.core.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.core.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.core.security.principal.PrincipalProvider;

public class PrincipalManagerImpl
implements PrincipalManager {
    private final Session session;
    private final PrincipalProvider[] providers;
    private boolean closed;

    public PrincipalManagerImpl(Session session, PrincipalProvider[] providers) {
        this.session = session;
        this.providers = providers;
        this.closed = false;
    }

    public boolean hasPrincipal(String principalName) {
        return this.internalGetPrincipal(principalName) != null;
    }

    public Principal getPrincipal(String principalName) throws NoSuchPrincipalException {
        Principal p = this.internalGetPrincipal(principalName);
        if (p == null) {
            throw new NoSuchPrincipalException("Unknown principal " + principalName);
        }
        return p;
    }

    public PrincipalIterator findPrincipals(String simpleFilter) {
        this.checkIsValid();
        ArrayList<CheckedIteratorEntry> entries = new ArrayList<CheckedIteratorEntry>(this.providers.length);
        for (int i = 0; i < this.providers.length; ++i) {
            PrincipalProvider pp = this.providers[i];
            PrincipalIterator it = pp.findPrincipals(simpleFilter);
            if (!it.hasNext()) continue;
            entries.add(new CheckedIteratorEntry(it, pp));
        }
        return new CheckedPrincipalIterator(entries);
    }

    public PrincipalIterator findPrincipals(String simpleFilter, int searchType) {
        this.checkIsValid();
        ArrayList<CheckedIteratorEntry> entries = new ArrayList<CheckedIteratorEntry>(this.providers.length);
        for (int i = 0; i < this.providers.length; ++i) {
            PrincipalProvider pp = this.providers[i];
            PrincipalIterator it = pp.findPrincipals(simpleFilter, searchType);
            if (!it.hasNext()) continue;
            entries.add(new CheckedIteratorEntry(it, pp));
        }
        return new CheckedPrincipalIterator(entries);
    }

    public PrincipalIterator getPrincipals(int searchType) {
        this.checkIsValid();
        ArrayList<CheckedIteratorEntry> entries = new ArrayList<CheckedIteratorEntry>(this.providers.length);
        for (int i = 0; i < this.providers.length; ++i) {
            PrincipalProvider pp = this.providers[i];
            PrincipalIterator it = pp.getPrincipals(searchType);
            if (!it.hasNext()) continue;
            entries.add(new CheckedIteratorEntry(it, pp));
        }
        return new CheckedPrincipalIterator(entries);
    }

    public PrincipalIterator getGroupMembership(Principal principal) {
        this.checkIsValid();
        ArrayList<CheckedIteratorEntry> entries = new ArrayList<CheckedIteratorEntry>(this.providers.length + 1);
        for (int i = 0; i < this.providers.length; ++i) {
            PrincipalProvider pp = this.providers[i];
            PrincipalIterator groups = pp.getGroupMembership(principal);
            if (!groups.hasNext()) continue;
            entries.add(new CheckedIteratorEntry(groups, pp));
        }
        if (!(principal instanceof EveryonePrincipal)) {
            Iterator<Principal> it = Collections.singletonList(this.getEveryone()).iterator();
            entries.add(new CheckedIteratorEntry(it, null));
        }
        return new CheckedPrincipalIterator(entries);
    }

    public Principal getEveryone() {
        this.checkIsValid();
        return EveryonePrincipal.getInstance();
    }

    private void checkIsValid() {
        if (this.closed) {
            throw new IllegalStateException("PrincipalManagerImpl instance has been closed.");
        }
    }

    private Principal internalGetPrincipal(String principalName) {
        this.checkIsValid();
        for (int i = 0; i < this.providers.length; ++i) {
            Principal principal = this.providers[i].getPrincipal(principalName);
            if (principal == null || !this.providers[i].canReadPrincipal(this.session, principal)) continue;
            return this.disguise(principal, this.providers[i]);
        }
        return null;
    }

    private Principal disguise(Principal principal, PrincipalProvider provider) {
        if (!(principal instanceof Group) || principal instanceof EveryonePrincipal) {
            return principal;
        }
        Group gr = (Group)principal;
        if (principal instanceof ItemBasedPrincipal) {
            return new ItemBasedCheckedGroup(gr, provider);
        }
        return new CheckedGroup(gr, provider);
    }

    private static class CheckedIteratorEntry {
        private final PrincipalProvider provider;
        private final Iterator iterator;

        private CheckedIteratorEntry(Iterator iterator, PrincipalProvider provider) {
            this.iterator = iterator;
            this.provider = provider;
        }
    }

    private class CheckedPrincipalIterator
    extends AbstractPrincipalIterator {
        private final List entries;

        private CheckedPrincipalIterator(Iterator it, PrincipalProvider provider) {
            this.entries = new ArrayList(1);
            this.entries.add(new CheckedIteratorEntry(it, provider));
            this.next = this.seekNext();
        }

        private CheckedPrincipalIterator(List entries) {
            this.entries = new ArrayList(entries);
            this.next = this.seekNext();
        }

        protected final Principal seekNext() {
            while (!this.entries.isEmpty()) {
                CheckedIteratorEntry current = (CheckedIteratorEntry)this.entries.get(0);
                Iterator iterator = current.iterator;
                while (iterator.hasNext()) {
                    Principal chk = (Principal)iterator.next();
                    if (current.provider != null && !current.provider.canReadPrincipal(PrincipalManagerImpl.this.session, chk)) continue;
                    return PrincipalManagerImpl.this.disguise(chk, current.provider);
                }
                this.entries.remove(0);
            }
            return null;
        }
    }

    private class ItemBasedCheckedGroup
    extends CheckedGroup
    implements ItemBasedPrincipal {
        private ItemBasedCheckedGroup(Group delegatee, PrincipalProvider provider) {
            super(delegatee, provider);
            if (!(delegatee instanceof ItemBasedPrincipal)) {
                throw new IllegalArgumentException();
            }
        }

        public String getPath() throws RepositoryException {
            return ((ItemBasedPrincipal)this.delegatee).getPath();
        }
    }

    private class CheckedGroup
    implements Group {
        final Group delegatee;
        private final PrincipalProvider provider;

        private CheckedGroup(Group delegatee, PrincipalProvider provider) {
            this.delegatee = delegatee;
            this.provider = provider;
        }

        public boolean addMember(Principal user) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public boolean removeMember(Principal user) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public boolean isMember(Principal member) {
            return this.delegatee.isMember(member);
        }

        public Enumeration members() {
            Iterator it = Collections.list(this.delegatee.members()).iterator();
            final CheckedPrincipalIterator members = new CheckedPrincipalIterator(it, this.provider);
            return new Enumeration(){

                public boolean hasMoreElements() {
                    return members.hasNext();
                }

                public Object nextElement() {
                    return members.next();
                }
            };
        }

        public String getName() {
            return this.delegatee.getName();
        }

        public int hashCode() {
            return this.delegatee.hashCode();
        }

        public boolean equals(Object obj) {
            return this.delegatee.equals(obj);
        }
    }
}

