/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import javax.jcr.NamespaceException;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.query.lucene.AbstractNamespaceMappings;

public class NSRegistryBasedNamespaceMappings
extends AbstractNamespaceMappings {
    private final NamespaceRegistryImpl nsReg;

    NSRegistryBasedNamespaceMappings(NamespaceRegistryImpl nsReg) {
        this.nsReg = nsReg;
    }

    public String getURI(String prefix) throws NamespaceException {
        try {
            int index = Integer.parseInt(prefix);
            return this.nsReg.indexToString(index);
        }
        catch (IllegalArgumentException e) {
            throw new NamespaceException("Unknown namespace prefix: " + prefix, e);
        }
    }

    public String getPrefix(String uri) throws NamespaceException {
        try {
            return String.valueOf(this.nsReg.stringToIndex(uri));
        }
        catch (IllegalArgumentException e) {
            throw new NamespaceException("Unknown namespace URI: " + uri, e);
        }
    }
}

