/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.query.lucene.TextExtractorReader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyTextExtractorField
extends AbstractField {
    private static final long serialVersionUID = -2707986404659820071L;
    private static final Logger log = LoggerFactory.getLogger(LazyTextExtractorField.class);
    private final Reader reader;
    private String extract;

    public LazyTextExtractorField(String name, Reader reader, boolean store, boolean withOffsets) {
        super(name, store ? Field.Store.YES : Field.Store.NO, Field.Index.ANALYZED, withOffsets ? Field.TermVector.WITH_OFFSETS : Field.TermVector.NO);
        this.reader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stringValue() {
        if (this.extract == null) {
            StringBuffer textExtract = new StringBuffer();
            char[] buffer = new char[1024];
            try {
                int len;
                while ((len = this.reader.read(buffer)) > -1) {
                    textExtract.append(buffer, 0, len);
                }
            }
            catch (IOException e) {
                log.warn("Exception reading value for field: " + e.getMessage());
                log.debug("Dump:", e);
            }
            finally {
                IOUtils.closeQuietly(this.reader);
            }
            this.extract = textExtract.toString();
        }
        return this.extract;
    }

    public Reader readerValue() {
        return null;
    }

    public byte[] binaryValue() {
        return null;
    }

    public TokenStream tokenStreamValue() {
        return null;
    }

    public boolean isExtractorFinished() {
        if (this.reader instanceof TextExtractorReader) {
            return ((TextExtractorReader)this.reader).isExtractorFinished();
        }
        return true;
    }

    public void dispose() throws IOException {
        this.reader.close();
    }
}

