/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import org.apache.jackrabbit.core.CachingHierarchyManager;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.SharedItemStateManager;

public class QueryHandlerContext {
    private final FileSystem fs;
    private final SharedItemStateManager stateMgr;
    private final CachingHierarchyManager hmgr;
    private final PersistenceManager pm;
    private final NodeTypeRegistry ntRegistry;
    private final NamespaceRegistryImpl nsRegistry;
    private NodeId rootId;
    private final PropertyTypeRegistry propRegistry;
    private final QueryHandler parentHandler;
    private final NodeId excludedNodeId;

    public QueryHandlerContext(FileSystem fs, SharedItemStateManager stateMgr, PersistenceManager pm, NodeId rootId, NodeTypeRegistry ntRegistry, NamespaceRegistryImpl nsRegistry, QueryHandler parentHandler, NodeId excludedNodeId) {
        this.fs = fs;
        this.stateMgr = stateMgr;
        this.hmgr = new CachingHierarchyManager(rootId, stateMgr);
        this.stateMgr.addListener(this.hmgr);
        this.pm = pm;
        this.rootId = rootId;
        this.ntRegistry = ntRegistry;
        this.nsRegistry = nsRegistry;
        this.propRegistry = new PropertyTypeRegistry(ntRegistry);
        this.parentHandler = parentHandler;
        this.excludedNodeId = excludedNodeId;
        ntRegistry.addListener(this.propRegistry);
    }

    public ItemStateManager getItemStateManager() {
        return this.stateMgr;
    }

    public HierarchyManager getHierarchyManager() {
        return this.hmgr;
    }

    public PersistenceManager getPersistenceManager() {
        return this.pm;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public NodeId getRootId() {
        return this.rootId;
    }

    public PropertyTypeRegistry getPropertyTypeRegistry() {
        return this.propRegistry;
    }

    public NodeTypeRegistry getNodeTypeRegistry() {
        return this.ntRegistry;
    }

    public NamespaceRegistryImpl getNamespaceRegistry() {
        return this.nsRegistry;
    }

    public QueryHandler getParentHandler() {
        return this.parentHandler;
    }

    public NodeId getExcludedNodeId() {
        return this.excludedNodeId;
    }

    public void destroy() {
        this.ntRegistry.removeListener(this.propRegistry);
    }
}

