/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.NetscapeDomainHandler;
import org.junit.Assert;
import org.junit.Test;

public class TestNetscapeCookieAttribHandlers {
    @Test
    public void testNetscapeDomainValidate1() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somehost", 80, "/", false);
        NetscapeDomainHandler h = new NetscapeDomainHandler();
        cookie.setDomain("somehost");
        h.validate((Cookie)cookie, origin);
        cookie.setDomain("otherhost");
        try {
            h.validate((Cookie)cookie, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException ex) {
            // empty catch block
        }
    }

    @Test
    public void testNetscapeDomainValidate2() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("www.somedomain.com", 80, "/", false);
        NetscapeDomainHandler h = new NetscapeDomainHandler();
        cookie.setDomain(".somedomain.com");
        h.validate((Cookie)cookie, origin);
        cookie.setDomain(".otherdomain.com");
        try {
            h.validate((Cookie)cookie, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException ex) {
            // empty catch block
        }
        cookie.setDomain("www.otherdomain.com");
        try {
            h.validate((Cookie)cookie, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException ex) {
            // empty catch block
        }
    }

    @Test
    public void testNetscapeDomainValidate3() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("www.a.com", 80, "/", false);
        NetscapeDomainHandler h = new NetscapeDomainHandler();
        cookie.setDomain(".a.com");
        h.validate((Cookie)cookie, origin);
        cookie.setDomain(".com");
        try {
            h.validate((Cookie)cookie, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException ex) {
            // empty catch block
        }
    }

    @Test
    public void testNetscapeDomainValidate4() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("www.a.b.c", 80, "/", false);
        NetscapeDomainHandler h = new NetscapeDomainHandler();
        cookie.setDomain(".a.b.c");
        h.validate((Cookie)cookie, origin);
        cookie.setDomain(".b.c");
        try {
            h.validate((Cookie)cookie, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException ex) {
            // empty catch block
        }
    }

    @Test
    public void testNetscapeDomainMatch1() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("www.somedomain.com", 80, "/", false);
        NetscapeDomainHandler h = new NetscapeDomainHandler();
        cookie.setDomain(null);
        Assert.assertFalse((boolean)h.match((Cookie)cookie, origin));
        cookie.setDomain(".somedomain.com");
        Assert.assertTrue((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testNetscapeDomainMatch2() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("www.whatever.somedomain.com", 80, "/", false);
        NetscapeDomainHandler h = new NetscapeDomainHandler();
        cookie.setDomain(".somedomain.com");
        Assert.assertTrue((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testNetscapeDomainInvalidInput() throws Exception {
        NetscapeDomainHandler h = new NetscapeDomainHandler();
        try {
            h.match(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            h.match((Cookie)new BasicClientCookie("name", "value"), null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

