/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.pool.ConnPoolControl;
import org.apache.http.pool.PoolStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MockConnPoolControl
implements ConnPoolControl<HttpRoute> {
    private final ConcurrentHashMap<HttpRoute, Integer> maxPerHostMap = new ConcurrentHashMap();
    private volatile int totalMax = 20;
    private volatile int defaultMax = 2;

    public void setMaxTotal(int max) {
        this.totalMax = max;
    }

    public int getMaxTotal() {
        return this.totalMax;
    }

    public PoolStats getTotalStats() {
        return new PoolStats(-1, -1, -1, this.totalMax);
    }

    public PoolStats getStats(HttpRoute route) {
        return new PoolStats(-1, -1, -1, this.getMaxPerRoute(route));
    }

    public int getDefaultMaxPerRoute() {
        return this.defaultMax;
    }

    public void setDefaultMaxPerRoute(int max) {
        this.defaultMax = max;
    }

    public void setMaxPerRoute(HttpRoute route, int max) {
        this.maxPerHostMap.put(route, max);
    }

    public int getMaxPerRoute(HttpRoute route) {
        Integer max = this.maxPerHostMap.get(route);
        if (max != null) {
            return max;
        }
        return this.defaultMax;
    }

    public void setMaxForRoutes(Map<HttpRoute, Integer> map) {
        if (map == null) {
            return;
        }
        this.maxPerHostMap.clear();
        this.maxPerHostMap.putAll(map);
    }

    public String toString() {
        return this.maxPerHostMap.toString();
    }
}

