/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.directory.server.kerberos.protocol.codec;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.ber.tlv.TLVStateEnum;
import org.apache.hadoop.hbase.shaded.org.apache.directory.server.kerberos.changepwd.exceptions.ChangePasswdErrorType;
import org.apache.hadoop.hbase.shaded.org.apache.directory.server.kerberos.changepwd.exceptions.ChangePasswordException;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.EncKdcRepPart.EncKdcRepPartContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.KerberosMessageContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.apRep.ApRepContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.apReq.ApReqContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.authenticator.AuthenticatorContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.authorizationData.AuthorizationDataContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.encApRepPart.EncApRepPartContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.encAsRepPart.EncAsRepPartContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.encKrbPrivPart.EncKrbPrivPartContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.encTgsRepPart.EncTgsRepPartContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.encTicketPart.EncTicketPartContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.encryptedData.EncryptedDataContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.encryptionKey.EncryptionKeyContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.krbPriv.KrbPrivContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.paEncTsEnc.PaEncTsEncContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.principalName.PrincipalNameContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.ticket.TicketContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.components.AuthorizationData;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.components.EncKdcRepPart;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.components.EncKrbPrivPart;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.components.EncTicketPart;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.components.EncryptedData;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.components.PaEncTsEnc;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.components.PrincipalName;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.exceptions.ErrorType;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.exceptions.KerberosException;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.messages.ApRep;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.messages.ApReq;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.messages.Authenticator;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.messages.EncApRepPart;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.messages.EncAsRepPart;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.messages.EncTgsRepPart;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.messages.KrbPriv;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.messages.Ticket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosDecoder {
    private static Logger LOG = LoggerFactory.getLogger(KerberosDecoder.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object decode(KerberosMessageContainer kerberosMessageContainer, Asn1Decoder asn1Decoder) throws DecoderException {
        ByteBuffer buf = kerberosMessageContainer.getStream();
        if (kerberosMessageContainer.isTCP()) {
            if (buf.remaining() <= 4) return null;
            kerberosMessageContainer.setTcpLength(buf.getInt());
            buf.mark();
        } else {
            buf.mark();
        }
        while (buf.hasRemaining()) {
            try {
                asn1Decoder.decode(buf, (Asn1Container)kerberosMessageContainer);
                if (kerberosMessageContainer.getState() != TLVStateEnum.PDU_DECODED) continue;
                if (!IS_DEBUG) return kerberosMessageContainer.getMessage();
                LOG.debug("Decoded KerberosMessage : " + kerberosMessageContainer.getMessage());
                buf.mark();
                return kerberosMessageContainer.getMessage();
            }
            catch (DecoderException de) {
                LOG.warn("error while decoding", (Throwable)de);
                buf.clear();
                kerberosMessageContainer.clean();
                throw de;
            }
        }
        return null;
    }

    public static EncryptedData decodeEncryptedData(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        EncryptedDataContainer encryptedDataContainer = new EncryptedDataContainer();
        Asn1Decoder kerberosDecoder = new Asn1Decoder();
        try {
            kerberosDecoder.decode(stream, (Asn1Container)encryptedDataContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        EncryptedData encryptedData = encryptedDataContainer.getEncryptedData();
        return encryptedData;
    }

    public static PaEncTsEnc decodePaEncTsEnc(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        PaEncTsEncContainer paEncTsEncContainer = new PaEncTsEncContainer();
        Asn1Decoder kerberosDecoder = new Asn1Decoder();
        try {
            kerberosDecoder.decode(stream, (Asn1Container)paEncTsEncContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        PaEncTsEnc paEncTsEnc = paEncTsEncContainer.getPaEncTsEnc();
        return paEncTsEnc;
    }

    public static EncApRepPart decodeEncApRepPart(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        EncApRepPartContainer encApRepPartContainer = new EncApRepPartContainer(stream);
        Asn1Decoder kerberosDecoder = new Asn1Decoder();
        try {
            kerberosDecoder.decode(stream, (Asn1Container)encApRepPartContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        EncApRepPart encApRepPart = encApRepPartContainer.getEncApRepPart();
        return encApRepPart;
    }

    public static EncKdcRepPart decodeEncKdcRepPart(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        EncKdcRepPartContainer encKdcRepPartContainer = new EncKdcRepPartContainer(stream);
        Asn1Decoder kerberosDecoder = new Asn1Decoder();
        try {
            kerberosDecoder.decode(stream, (Asn1Container)encKdcRepPartContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        EncKdcRepPart encKdcRepPart = encKdcRepPartContainer.getEncKdcRepPart();
        return encKdcRepPart;
    }

    public static EncKrbPrivPart decodeEncKrbPrivPart(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        EncKrbPrivPartContainer encKrbPrivPartContainer = new EncKrbPrivPartContainer(stream);
        Asn1Decoder kerberosDecoder = new Asn1Decoder();
        try {
            kerberosDecoder.decode(stream, (Asn1Container)encKrbPrivPartContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        EncKrbPrivPart encKrbPrivPart = encKrbPrivPartContainer.getEncKrbPrivPart();
        return encKrbPrivPart;
    }

    public static EncTicketPart decodeEncTicketPart(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        EncTicketPartContainer encTicketPartContainer = new EncTicketPartContainer(stream);
        Asn1Decoder kerberosDecoder = new Asn1Decoder();
        try {
            kerberosDecoder.decode(stream, (Asn1Container)encTicketPartContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        EncTicketPart encTicketPart = encTicketPartContainer.getEncTicketPart();
        return encTicketPart;
    }

    public static EncryptionKey decodeEncryptionKey(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        EncryptionKeyContainer encryptionKeyContainer = new EncryptionKeyContainer();
        Asn1Decoder kerberosDecoder = new Asn1Decoder();
        try {
            kerberosDecoder.decode(stream, (Asn1Container)encryptionKeyContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        EncryptionKey encryptionKey = encryptionKeyContainer.getEncryptionKey();
        return encryptionKey;
    }

    public static PrincipalName decodePrincipalName(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        PrincipalNameContainer principalNameContainer = new PrincipalNameContainer();
        Asn1Decoder kerberosDecoder = new Asn1Decoder();
        try {
            kerberosDecoder.decode(stream, (Asn1Container)principalNameContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        PrincipalName principalName = principalNameContainer.getPrincipalName();
        return principalName;
    }

    public static Ticket decodeTicket(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        TicketContainer ticketContainer = new TicketContainer(stream);
        Asn1Decoder kerberosDecoder = new Asn1Decoder();
        try {
            kerberosDecoder.decode(stream, (Asn1Container)ticketContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        Ticket ticket = ticketContainer.getTicket();
        return ticket;
    }

    public static Authenticator decodeAuthenticator(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        AuthenticatorContainer authenticatorContainer = new AuthenticatorContainer(stream);
        Asn1Decoder kerberosDecoder = new Asn1Decoder();
        try {
            kerberosDecoder.decode(stream, (Asn1Container)authenticatorContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        Authenticator authenticator = authenticatorContainer.getAuthenticator();
        return authenticator;
    }

    public static AuthorizationData decodeAuthorizationData(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        AuthorizationDataContainer authorizationDataContainer = new AuthorizationDataContainer();
        Asn1Decoder kerberosDecoder = new Asn1Decoder();
        try {
            kerberosDecoder.decode(stream, (Asn1Container)authorizationDataContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        AuthorizationData authorizationData = authorizationDataContainer.getAuthorizationData();
        return authorizationData;
    }

    public static ApRep decodeApRep(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        ApRepContainer apRepContainer = new ApRepContainer(stream);
        Asn1Decoder kerberosDecoder = new Asn1Decoder();
        try {
            kerberosDecoder.decode(stream, (Asn1Container)apRepContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        ApRep apRep = apRepContainer.getApRep();
        return apRep;
    }

    public static ApReq decodeApReq(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        ApReqContainer apReqContainer = new ApReqContainer(stream);
        Asn1Decoder kerberosDecoder = new Asn1Decoder();
        try {
            kerberosDecoder.decode(stream, (Asn1Container)apReqContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        ApReq apReq = apReqContainer.getApReq();
        return apReq;
    }

    public static KrbPriv decodeKrbPriv(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        KrbPrivContainer krbPrivContainer = new KrbPrivContainer(stream);
        Asn1Decoder kerberosDecoder = new Asn1Decoder();
        try {
            kerberosDecoder.decode(stream, (Asn1Container)krbPrivContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        KrbPriv krbPriv = krbPrivContainer.getKrbPriv();
        return krbPriv;
    }

    public static EncAsRepPart decodeEncAsRepPart(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        EncAsRepPartContainer encAsRepPartContainer = new EncAsRepPartContainer(stream);
        Asn1Decoder kerberosDecoder = new Asn1Decoder();
        try {
            kerberosDecoder.decode(stream, (Asn1Container)encAsRepPartContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        EncAsRepPart encAsRepPart = encAsRepPartContainer.getEncAsRepPart();
        return encAsRepPart;
    }

    public static EncTgsRepPart decodeEncTgsRepPart(byte[] data) throws ChangePasswordException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        EncTgsRepPartContainer encTgsRepPartContainer = new EncTgsRepPartContainer(stream);
        Asn1Decoder kerberosDecoder = new Asn1Decoder();
        try {
            kerberosDecoder.decode(stream, (Asn1Container)encTgsRepPartContainer);
        }
        catch (DecoderException de) {
            throw new ChangePasswordException(ChangePasswdErrorType.KRB5_KPASSWD_MALFORMED, (Throwable)de);
        }
        EncTgsRepPart encTgsRepPart = encTgsRepPartContainer.getEncTgsRepPart();
        return encTgsRepPart;
    }
}

