/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class SecureBulkLoadUtil {
    private static final String BULKLOAD_STAGING_DIR = "hbase.bulkload.staging.dir";

    public static Path getStagingPath(Configuration conf, String bulkToken, byte[] family) {
        Path stageP = new Path(SecureBulkLoadUtil.getBaseStagingDir(conf), bulkToken);
        return new Path(stageP, Bytes.toString(family));
    }

    public static Path getBaseStagingDir(Configuration conf) {
        String hbaseTmpFsDir = conf.get("hbase.fs.tmp.dir", HConstants.DEFAULT_TEMPORARY_HDFS_DIRECTORY);
        return new Path(conf.get(BULKLOAD_STAGING_DIR, hbaseTmpFsDir));
    }
}

