/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.WALCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.WALObserver;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;

@InterfaceAudience.Private
public class WALCoprocessorHost
extends CoprocessorHost<WALEnvironment> {
    FSHLog wal;

    public WALCoprocessorHost(FSHLog log, Configuration conf) {
        super(null);
        this.wal = log;
        this.loadSystemCoprocessors(conf, "hbase.coprocessor.wal.classes");
    }

    @Override
    public WALEnvironment createEnvironment(Class<?> implClass, Coprocessor instance, int priority, int seq, Configuration conf) {
        return new WALEnvironment(implClass, instance, priority, seq, conf, this.wal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preWALWrite(HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        boolean bypass = false;
        ObserverContext<WALCoprocessorEnvironment> ctx = null;
        for (WALEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof WALObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((WALObserver)env.getInstance()).preWALWrite(ctx, info, logKey, logEdit);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postWALWrite(HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        ObserverContext<WALCoprocessorEnvironment> ctx = null;
        for (WALEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof WALObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((WALObserver)env.getInstance()).postWALWrite(ctx, info, logKey, logEdit);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    static class WALEnvironment
    extends CoprocessorHost.Environment
    implements WALCoprocessorEnvironment {
        private FSHLog wal;

        @Override
        public FSHLog getWAL() {
            return this.wal;
        }

        public WALEnvironment(Class<?> implClass, Coprocessor impl, int priority, int seq, Configuration conf, FSHLog hlog) {
            super(impl, priority, seq, conf);
            this.wal = hlog;
        }
    }
}

