/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.monitoring;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandlerImpl;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.MonitoredTaskImpl;

@InterfaceAudience.Private
public class TaskMonitor {
    private static final Log LOG = LogFactory.getLog(TaskMonitor.class);
    private static final long EXPIRATION_TIME = 60000L;
    @VisibleForTesting
    static final int MAX_TASKS = 1000;
    private static TaskMonitor instance;
    private CircularFifoBuffer tasks = new CircularFifoBuffer(1000);

    public static synchronized TaskMonitor get() {
        if (instance == null) {
            instance = new TaskMonitor();
        }
        return instance;
    }

    public synchronized MonitoredTask createStatus(String description) {
        MonitoredTaskImpl stat = new MonitoredTaskImpl();
        stat.setDescription(description);
        MonitoredTask proxy = (MonitoredTask)Proxy.newProxyInstance(stat.getClass().getClassLoader(), new Class[]{MonitoredTask.class}, new PassthroughInvocationHandler<MonitoredTaskImpl>(stat));
        TaskAndWeakRefPair pair = new TaskAndWeakRefPair(stat, proxy);
        this.tasks.add((Object)pair);
        return proxy;
    }

    public synchronized MonitoredRPCHandler createRPCStatus(String description) {
        MonitoredRPCHandlerImpl stat = new MonitoredRPCHandlerImpl();
        stat.setDescription(description);
        MonitoredRPCHandler proxy = (MonitoredRPCHandler)Proxy.newProxyInstance(stat.getClass().getClassLoader(), new Class[]{MonitoredRPCHandler.class}, new PassthroughInvocationHandler<MonitoredRPCHandlerImpl>(stat));
        TaskAndWeakRefPair pair = new TaskAndWeakRefPair(stat, proxy);
        this.tasks.add((Object)pair);
        return proxy;
    }

    private synchronized void purgeExpiredTasks() {
        Iterator it = this.tasks.iterator();
        while (it.hasNext()) {
            TaskAndWeakRefPair pair = (TaskAndWeakRefPair)it.next();
            MonitoredTask stat = pair.get();
            if (pair.isDead() && stat.getState() == MonitoredTask.State.RUNNING) {
                LOG.warn((Object)("Status " + stat + " appears to have been leaked"));
                stat.cleanup();
            }
            if (!this.canPurge(stat)) continue;
            it.remove();
        }
    }

    public synchronized List<MonitoredTask> getTasks() {
        this.purgeExpiredTasks();
        ArrayList ret = Lists.newArrayListWithCapacity((int)this.tasks.size());
        for (TaskAndWeakRefPair pair : this.tasks) {
            MonitoredTask t = pair.get();
            ret.add(t.clone());
        }
        return ret;
    }

    private boolean canPurge(MonitoredTask stat) {
        long cts = stat.getCompletionTimestamp();
        return cts > 0L && System.currentTimeMillis() - cts > 60000L;
    }

    public void dumpAsText(PrintWriter out) {
        long now = System.currentTimeMillis();
        List<MonitoredTask> tasks = this.getTasks();
        for (MonitoredTask task : tasks) {
            out.println("Task: " + task.getDescription());
            out.println("Status: " + (Object)((Object)task.getState()) + ":" + task.getStatus());
            long running = (now - task.getStartTime()) / 1000L;
            if (task.getCompletionTimestamp() != -1L) {
                long completed = (now - task.getCompletionTimestamp()) / 1000L;
                out.println("Completed " + completed + "s ago");
                out.println("Ran for " + (task.getCompletionTimestamp() - task.getStartTime()) / 1000L + "s");
            } else {
                out.println("Running for " + running + "s");
            }
            out.println();
        }
    }

    private static class PassthroughInvocationHandler<T>
    implements InvocationHandler {
        private T delegatee;

        public PassthroughInvocationHandler(T delegatee) {
            this.delegatee = delegatee;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke(this.delegatee, args);
        }
    }

    private static class TaskAndWeakRefPair {
        private MonitoredTask impl;
        private WeakReference<MonitoredTask> weakProxy;

        public TaskAndWeakRefPair(MonitoredTask stat, MonitoredTask proxy) {
            this.impl = stat;
            this.weakProxy = new WeakReference<MonitoredTask>(proxy);
        }

        public MonitoredTask get() {
            return this.impl;
        }

        public boolean isDead() {
            return this.weakProxy.get() == null;
        }
    }
}

