/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.histogram;

import com.yammer.metrics.stats.ExponentiallyDecayingSample;
import com.yammer.metrics.stats.Sample;
import com.yammer.metrics.stats.Snapshot;
import com.yammer.metrics.stats.UniformSample;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsRegistry;

@Deprecated
public class MetricsHistogram
extends MetricsBase {
    private static final int DEFAULT_SAMPLE_SIZE = 1028;
    private static final double DEFAULT_ALPHA = 0.015;
    public static final String NUM_OPS_METRIC_NAME = "_num_ops";
    public static final String MIN_METRIC_NAME = "_min";
    public static final String MAX_METRIC_NAME = "_max";
    public static final String MEAN_METRIC_NAME = "_mean";
    public static final String STD_DEV_METRIC_NAME = "_std_dev";
    public static final String MEDIAN_METRIC_NAME = "_median";
    public static final String SEVENTY_FIFTH_PERCENTILE_METRIC_NAME = "_75th_percentile";
    public static final String NINETY_FIFTH_PERCENTILE_METRIC_NAME = "_95th_percentile";
    public static final String NINETY_NINETH_PERCENTILE_METRIC_NAME = "_99th_percentile";
    private final Sample sample;
    private final AtomicLong min = new AtomicLong();
    private final AtomicLong max = new AtomicLong();
    private final AtomicLong sum = new AtomicLong();
    private final AtomicReference<double[]> variance;
    private final AtomicLong count;

    public MetricsHistogram(String nam, MetricsRegistry registry, String description, boolean forwardBiased) {
        super(nam, description);
        this.sample = forwardBiased ? new ExponentiallyDecayingSample(1028, 0.015) : new UniformSample(1028);
        this.variance = new AtomicReference<double[]>(new double[]{-1.0, 0.0});
        this.count = new AtomicLong();
        this.clear();
        if (registry != null) {
            registry.add(nam, (MetricsBase)this);
        }
    }

    public MetricsHistogram(String nam, MetricsRegistry registry, String description) {
        this(nam, registry, "NoDescription", true);
    }

    public MetricsHistogram(String nam, MetricsRegistry registry) {
        this(nam, registry, "NoDescription");
    }

    public void clear() {
        this.sample.clear();
        this.count.set(0L);
        this.max.set(Long.MIN_VALUE);
        this.min.set(Long.MAX_VALUE);
        this.sum.set(0L);
        this.variance.set(new double[]{-1.0, 0.0});
    }

    public void update(int val) {
        this.update((long)val);
    }

    public void update(long val) {
        this.count.incrementAndGet();
        this.sample.update(val);
        this.setMax(val);
        this.setMin(val);
        this.sum.getAndAdd(val);
        this.updateVariance(val);
    }

    private void setMax(long potentialMax) {
        boolean done = false;
        while (!done) {
            long currentMax = this.max.get();
            done = currentMax >= potentialMax || this.max.compareAndSet(currentMax, potentialMax);
        }
    }

    private void setMin(long potentialMin) {
        boolean done = false;
        while (!done) {
            long currentMin = this.min.get();
            done = currentMin <= potentialMin || this.min.compareAndSet(currentMin, potentialMin);
        }
    }

    private void updateVariance(long value) {
        boolean done = false;
        while (!done) {
            double[] oldValues = this.variance.get();
            double[] newValues = new double[2];
            if (oldValues[0] == -1.0) {
                newValues[0] = value;
                newValues[1] = 0.0;
            } else {
                double oldM = oldValues[0];
                double oldS = oldValues[1];
                double newM = oldM + ((double)value - oldM) / (double)this.getCount();
                double newS = oldS + ((double)value - oldM) * ((double)value - newM);
                newValues[0] = newM;
                newValues[1] = newS;
            }
            done = this.variance.compareAndSet(oldValues, newValues);
        }
    }

    public long getCount() {
        return this.count.get();
    }

    public long getMax() {
        if (this.getCount() > 0L) {
            return this.max.get();
        }
        return 0L;
    }

    public long getMin() {
        if (this.getCount() > 0L) {
            return this.min.get();
        }
        return 0L;
    }

    public double getMean() {
        if (this.getCount() > 0L) {
            return (double)this.sum.get() / (double)this.getCount();
        }
        return 0.0;
    }

    public double getStdDev() {
        if (this.getCount() > 0L) {
            return Math.sqrt(this.getVariance());
        }
        return 0.0;
    }

    public Snapshot getSnapshot() {
        return this.sample.getSnapshot();
    }

    private double getVariance() {
        if (this.getCount() <= 1L) {
            return 0.0;
        }
        return this.variance.get()[1] / (double)(this.getCount() - 1L);
    }

    public void pushMetric(MetricsRecord mr) {
        Snapshot s = this.getSnapshot();
        mr.setMetric(this.getName() + NUM_OPS_METRIC_NAME, this.getCount());
        mr.setMetric(this.getName() + MIN_METRIC_NAME, this.getMin());
        mr.setMetric(this.getName() + MAX_METRIC_NAME, this.getMax());
        mr.setMetric(this.getName() + MEAN_METRIC_NAME, (float)this.getMean());
        mr.setMetric(this.getName() + STD_DEV_METRIC_NAME, (float)this.getStdDev());
        mr.setMetric(this.getName() + MEDIAN_METRIC_NAME, (float)s.getMedian());
        mr.setMetric(this.getName() + SEVENTY_FIFTH_PERCENTILE_METRIC_NAME, (float)s.get75thPercentile());
        mr.setMetric(this.getName() + NINETY_FIFTH_PERCENTILE_METRIC_NAME, (float)s.get95thPercentile());
        mr.setMetric(this.getName() + NINETY_NINETH_PERCENTILE_METRIC_NAME, (float)s.get99thPercentile());
    }
}

