/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.coprocessor.BaseMasterObserver;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestEnableTableHandler {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestEnableTableHandler.class);
    private static final byte[] FAMILYNAME = Bytes.toBytes((String)"fam");

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.getConfiguration().set("hbase.balancer.tablesOnMaster", "hbase:meta");
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.master.classes", MasterSyncObserver.class.getName());
        TEST_UTIL.startMiniCluster(1, 2);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=300000L)
    public void testDisableTableAndRestart() throws Exception {
        final TableName tableName = TableName.valueOf((String)"testDisableTableAndRestart");
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILYNAME));
        admin.createTable(desc);
        admin.disableTable(tableName);
        TEST_UTIL.waitTableDisabled(tableName.getName());
        TEST_UTIL.getHBaseCluster().shutdown();
        TEST_UTIL.getHBaseCluster().waitUntilShutDown();
        TEST_UTIL.restartHBaseCluster(2);
        final HBaseAdmin newAdmin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        newAdmin.enableTable(tableName);
        TEST_UTIL.waitFor(10000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return newAdmin.isTableAvailable(tableName);
            }
        });
    }

    public static void createTable(HBaseTestingUtility testUtil, HTableDescriptor htd, byte[][] splitKeys) throws Exception {
        TestEnableTableHandler.createTable(testUtil, testUtil.getHBaseAdmin(), htd, splitKeys);
    }

    public static void createTable(HBaseTestingUtility testUtil, HBaseAdmin admin, HTableDescriptor htd, byte[][] splitKeys) throws Exception {
        MasterSyncObserver observer = (MasterSyncObserver)testUtil.getHBaseCluster().getMaster().getCoprocessorHost().findCoprocessor(MasterSyncObserver.class.getName());
        observer.tableCreationLatch = new CountDownLatch(1);
        if (splitKeys != null) {
            admin.createTable(htd, splitKeys);
        } else {
            admin.createTable(htd);
        }
        observer.tableCreationLatch.await();
        observer.tableCreationLatch = null;
        testUtil.waitUntilAllRegionsAssigned(htd.getTableName());
    }

    public static void deleteTable(HBaseTestingUtility testUtil, TableName tableName) throws Exception {
        TestEnableTableHandler.deleteTable(testUtil, testUtil.getHBaseAdmin(), tableName);
    }

    public static void deleteTable(HBaseTestingUtility testUtil, HBaseAdmin admin, TableName tableName) throws Exception {
        MasterSyncObserver observer = (MasterSyncObserver)testUtil.getHBaseCluster().getMaster().getCoprocessorHost().findCoprocessor(MasterSyncObserver.class.getName());
        observer.tableDeletionLatch = new CountDownLatch(1);
        try {
            admin.disableTable(tableName);
        }
        catch (Exception e) {
            LOG.debug((Object)("Table: " + tableName + " already disabled, so just deleting it."));
        }
        admin.deleteTable(tableName);
        observer.tableDeletionLatch.await();
        observer.tableDeletionLatch = null;
    }

    public static class MasterSyncObserver
    extends BaseMasterObserver {
        volatile CountDownLatch tableCreationLatch = null;
        volatile CountDownLatch tableDeletionLatch = null;

        public void postCreateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
            if (this.tableCreationLatch != null) {
                this.tableCreationLatch.countDown();
            }
        }

        public void postDeleteTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
            if (this.tableDeletionLatch != null) {
                this.tableDeletionLatch.countDown();
            }
        }
    }
}

