/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionThroughputController;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestIOFencing {
    static final Log LOG = LogFactory.getLog(TestIOFencing.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"tabletest");
    private static final byte[] FAMILY = Bytes.toBytes((String)"family");
    private static final int FIRST_BATCH_COUNT = 4000;
    private static final int SECOND_BATCH_COUNT = 4000;

    @Ignore(value="See HBASE-10298")
    @Test
    public void testFencingAroundCompaction() throws Exception {
        this.doTest(BlockCompactionsInPrepRegion.class, false);
        this.doTest(BlockCompactionsInPrepRegion.class, true);
    }

    @Ignore(value="See HBASE-10298")
    @Test
    public void testFencingAroundCompactionAfterWALSync() throws Exception {
        this.doTest(BlockCompactionsInCompletionRegion.class, false);
        this.doTest(BlockCompactionsInCompletionRegion.class, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTest(Class<?> regionClass, boolean distributedLogReplay) throws Exception {
        Configuration c = TEST_UTIL.getConfiguration();
        c.setBoolean("hbase.master.distributed.log.replay", distributedLogReplay);
        c.setClass("hbase.hregion.impl", regionClass, HRegion.class);
        c.setBoolean("dfs.support.append", true);
        c.setLong("hbase.hregion.memstore.flush.size", 200000L);
        c.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        c.setInt("hbase.hstore.compactionThreshold", 1000);
        c.setLong("hbase.hstore.blockingStoreFiles", 1000L);
        c.setInt("hbase.regionserver.thread.splitcompactcheckfrequency", 1000);
        LOG.info((Object)"Starting mini cluster");
        TEST_UTIL.startMiniCluster(1);
        CompactionBlockerRegion compactingRegion = null;
        HBaseAdmin admin = null;
        try {
            LOG.info((Object)"Creating admin");
            admin = new HBaseAdmin(c);
            LOG.info((Object)"Creating table");
            TEST_UTIL.createTable(TABLE_NAME, FAMILY);
            HTable table = new HTable(c, TABLE_NAME);
            LOG.info((Object)"Loading test table");
            List<HRegion> testRegions = TEST_UTIL.getMiniHBaseCluster().findRegionsForTable(TABLE_NAME);
            Assert.assertEquals((long)1L, (long)testRegions.size());
            compactingRegion = (CompactionBlockerRegion)testRegions.get(0);
            LOG.info((Object)"Blocking compactions");
            compactingRegion.stopCompactions();
            long lastFlushTime = compactingRegion.getLastFlushTime();
            TEST_UTIL.loadNumericRows(table, FAMILY, 0, 4000);
            HRegionInfo oldHri = new HRegionInfo(table.getName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            WALProtos.CompactionDescriptor compactionDescriptor = ProtobufUtil.toCompactionDescriptor((HRegionInfo)oldHri, (byte[])FAMILY, (List)Lists.newArrayList((Object[])new Path[]{new Path("/a")}), (List)Lists.newArrayList((Object[])new Path[]{new Path("/b")}), (Path)new Path("store_dir"));
            HLogUtil.writeCompactionMarker((HLog)compactingRegion.getLog(), (HTableDescriptor)table.getTableDescriptor(), (HRegionInfo)oldHri, (WALProtos.CompactionDescriptor)compactionDescriptor, (AtomicLong)new AtomicLong(9223372036854775707L));
            long startWaitTime = System.currentTimeMillis();
            while (compactingRegion.getLastFlushTime() <= lastFlushTime || compactingRegion.countStoreFiles() <= 1) {
                LOG.info((Object)("Waiting for the region to flush " + compactingRegion.getRegionNameAsString()));
                Thread.sleep(1000L);
                Assert.assertTrue((String)"Timed out waiting for the region to flush", (System.currentTimeMillis() - startWaitTime < 30000L ? 1 : 0) != 0);
            }
            Assert.assertTrue((compactingRegion.countStoreFiles() > 1 ? 1 : 0) != 0);
            final byte[] REGION_NAME = compactingRegion.getRegionName();
            LOG.info((Object)"Asking for compaction");
            admin.majorCompact(TABLE_NAME.getName());
            LOG.info((Object)"Waiting for compaction to be about to start");
            compactingRegion.waitForCompactionToBlock();
            LOG.info((Object)"Starting a new server");
            JVMClusterUtil.RegionServerThread newServerThread = TEST_UTIL.getMiniHBaseCluster().startRegionServer();
            final HRegionServer newServer = newServerThread.getRegionServer();
            LOG.info((Object)"Killing region server ZK lease");
            TEST_UTIL.expireRegionServerSession(0);
            CompactionBlockerRegion newRegion = null;
            startWaitTime = System.currentTimeMillis();
            LOG.info((Object)("Waiting for the new server to pick up the region " + Bytes.toString((byte[])REGION_NAME)));
            Waiter.waitFor((Configuration)c, (long)60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    HRegion newRegion = newServer.getOnlineRegion(REGION_NAME);
                    return newRegion != null && !newRegion.isRecovering();
                }
            });
            newRegion = (CompactionBlockerRegion)newServer.getOnlineRegion(REGION_NAME);
            LOG.info((Object)"Allowing compaction to proceed");
            compactingRegion.allowCompactions();
            while (compactingRegion.compactCount == 0) {
                Thread.sleep(1000L);
            }
            LOG.info((Object)"Compaction finished");
            FileSystem fs = newRegion.getFilesystem();
            for (String f : newRegion.getStoreFileList(new byte[][]{FAMILY})) {
                Assert.assertTrue((String)("After compaction, does not exist: " + f), (boolean)fs.exists(new Path(f)));
            }
            TEST_UTIL.loadNumericRows(table, FAMILY, 4000, 8000);
            admin.majorCompact(TABLE_NAME.getName());
            startWaitTime = System.currentTimeMillis();
            while (newRegion.compactCount == 0) {
                Thread.sleep(1000L);
                Assert.assertTrue((String)"New region never compacted", (System.currentTimeMillis() - startWaitTime < 180000L ? 1 : 0) != 0);
            }
            Assert.assertEquals((long)8000L, (long)TEST_UTIL.countRows(table));
        }
        finally {
            if (compactingRegion != null) {
                compactingRegion.allowCompactions();
            }
            admin.close();
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    public static class BlockCompactionsInCompletionHStore
    extends HStore {
        CompactionBlockerRegion r;

        protected BlockCompactionsInCompletionHStore(HRegion region, HColumnDescriptor family, Configuration confParam) throws IOException {
            super(region, family, confParam);
            this.r = (CompactionBlockerRegion)region;
        }

        protected void completeCompaction(Collection<StoreFile> compactedFiles) throws IOException {
            try {
                this.r.compactionsWaiting.countDown();
                this.r.compactionsBlocked.await();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
            super.completeCompaction(compactedFiles);
        }
    }

    public static class BlockCompactionsInCompletionRegion
    extends CompactionBlockerRegion {
        public BlockCompactionsInCompletionRegion(Path tableDir, HLog log, FileSystem fs, Configuration confParam, HRegionInfo info, HTableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, log, fs, confParam, info, htd, rsServices);
        }

        protected HStore instantiateHStore(HColumnDescriptor family) throws IOException {
            return new BlockCompactionsInCompletionHStore(this, family, this.conf);
        }
    }

    public static class BlockCompactionsInPrepRegion
    extends CompactionBlockerRegion {
        public BlockCompactionsInPrepRegion(Path tableDir, HLog log, FileSystem fs, Configuration confParam, HRegionInfo info, HTableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, log, fs, confParam, info, htd, rsServices);
        }

        protected void doRegionCompactionPrep() throws IOException {
            this.compactionsWaiting.countDown();
            try {
                this.compactionsBlocked.await();
            }
            catch (InterruptedException ex) {
                throw new IOException();
            }
            super.doRegionCompactionPrep();
        }
    }

    public static abstract class CompactionBlockerRegion
    extends HRegion {
        volatile int compactCount = 0;
        volatile CountDownLatch compactionsBlocked = new CountDownLatch(0);
        volatile CountDownLatch compactionsWaiting = new CountDownLatch(0);

        public CompactionBlockerRegion(Path tableDir, HLog log, FileSystem fs, Configuration confParam, HRegionInfo info, HTableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, log, fs, confParam, info, htd, rsServices);
        }

        public void stopCompactions() {
            this.compactionsBlocked = new CountDownLatch(1);
            this.compactionsWaiting = new CountDownLatch(1);
        }

        public void allowCompactions() {
            LOG.debug((Object)"allowing compactions");
            this.compactionsBlocked.countDown();
        }

        public void waitForCompactionToBlock() throws IOException {
            try {
                LOG.debug((Object)"waiting for compaction to block");
                this.compactionsWaiting.await();
                LOG.debug((Object)"compaction block reached");
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean compact(CompactionContext compaction, Store store, CompactionThroughputController throughputController) throws IOException {
            try {
                boolean bl = super.compact(compaction, store, throughputController);
                return bl;
            }
            finally {
                ++this.compactCount;
            }
        }

        public int countStoreFiles() {
            int count = 0;
            for (Store store : this.stores.values()) {
                count += store.getStorefilesCount();
            }
            return count;
        }
    }
}

