/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.encoding.BufferedDataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.CompressionState;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.EncoderBufferTooSmallException;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class FastDiffDeltaEncoder
extends BufferedDataBlockEncoder {
    final int MASK_TIMESTAMP_LENGTH = 7;
    final int SHIFT_TIMESTAMP_LENGTH = 0;
    final int FLAG_SAME_KEY_LENGTH = 8;
    final int FLAG_SAME_VALUE_LENGTH = 16;
    final int FLAG_SAME_TYPE = 32;
    final int FLAG_SAME_VALUE = 64;

    private void compressSingleKeyValue(FastDiffCompressionState previousState, FastDiffCompressionState currentState, OutputStream out, ByteBuffer in) throws IOException {
        currentState.prevOffset = in.position();
        int keyLength = in.getInt();
        int valueOffset = currentState.prevOffset + keyLength + 8;
        int valueLength = in.getInt();
        int flag = 0;
        if (previousState.isFirst()) {
            out.write(flag);
            ByteBufferUtils.putCompressedInt(out, keyLength);
            ByteBufferUtils.putCompressedInt(out, valueLength);
            ByteBufferUtils.putCompressedInt(out, 0);
            currentState.readKey(in, keyLength, valueLength);
            ByteBufferUtils.moveBufferToStream(out, in, keyLength + valueLength);
        } else {
            int previousValueOffset;
            int commonPrefix = ByteBufferUtils.findCommonPrefix(in, in.position(), previousState.prevOffset + 8, Math.min(keyLength, previousState.keyLength) - 9);
            currentState.readKey(in, keyLength, valueLength, commonPrefix, previousState);
            if (keyLength == previousState.keyLength) {
                flag = (byte)(flag | 8);
            }
            if (valueLength == previousState.valueLength) {
                flag = (byte)(flag | 0x10);
            }
            if (currentState.type == previousState.type) {
                flag = (byte)(flag | 0x20);
            }
            int commonTimestampPrefix = this.findCommonTimestampPrefix(currentState, previousState);
            flag = (byte)(flag | commonTimestampPrefix << 0);
            if (valueLength == previousState.valueLength && ByteBufferUtils.arePartsEqual(in, previousValueOffset = previousState.prevOffset + previousState.keyLength + 8, previousState.valueLength, valueOffset, valueLength)) {
                flag = (byte)(flag | 0x40);
            }
            out.write(flag);
            if ((flag & 8) == 0) {
                ByteBufferUtils.putCompressedInt(out, keyLength);
            }
            if ((flag & 0x10) == 0) {
                ByteBufferUtils.putCompressedInt(out, valueLength);
            }
            ByteBufferUtils.putCompressedInt(out, commonPrefix);
            ByteBufferUtils.skip(in, commonPrefix);
            if (commonPrefix < currentState.rowLength + 2) {
                ByteBufferUtils.moveBufferToStream(out, in, currentState.rowLength + 2 - commonPrefix);
                ByteBufferUtils.skip(in, currentState.familyLength + 1);
                ByteBufferUtils.moveBufferToStream(out, in, currentState.qualifierLength);
            } else {
                int restKeyLength = keyLength - commonPrefix - 9;
                ByteBufferUtils.moveBufferToStream(out, in, restKeyLength);
            }
            ByteBufferUtils.skip(in, commonTimestampPrefix);
            ByteBufferUtils.moveBufferToStream(out, in, 8 - commonTimestampPrefix);
            if ((flag & 0x20) == 0) {
                out.write(currentState.type);
            }
            if ((flag & 0x40) == 0) {
                ByteBufferUtils.copyBufferToStream(out, in, valueOffset, valueLength);
            }
            ByteBufferUtils.skip(in, 1 + currentState.valueLength);
        }
    }

    private int findCommonTimestampPrefix(FastDiffCompressionState left, FastDiffCompressionState right) {
        int prefixTimestamp;
        for (prefixTimestamp = 0; prefixTimestamp < 7 && left.timestamp[prefixTimestamp] == right.timestamp[prefixTimestamp]; ++prefixTimestamp) {
        }
        return prefixTimestamp;
    }

    private void uncompressSingleKeyValue(DataInputStream source, ByteBuffer out, FastDiffCompressionState state) throws IOException, EncoderBufferTooSmallException {
        byte flag = source.readByte();
        int prevKeyLength = state.keyLength;
        if ((flag & 8) == 0) {
            state.keyLength = ByteBufferUtils.readCompressedInt(source);
        }
        if ((flag & 0x10) == 0) {
            state.valueLength = ByteBufferUtils.readCompressedInt(source);
        }
        int commonLength = ByteBufferUtils.readCompressedInt(source);
        FastDiffDeltaEncoder.ensureSpace(out, state.keyLength + state.valueLength + 8);
        int kvPos = out.position();
        if (!state.isFirst()) {
            int keyRestLength;
            int common;
            int prevOffset;
            if ((flag & 0x10) == 0) {
                out.putInt(state.keyLength);
                out.putInt(state.valueLength);
                prevOffset = state.prevOffset + 8;
                common = commonLength;
            } else if ((flag & 8) != 0) {
                prevOffset = state.prevOffset;
                common = commonLength + 8;
            } else {
                out.putInt(state.keyLength);
                prevOffset = state.prevOffset + 4;
                common = commonLength + 4;
            }
            ByteBufferUtils.copyFromBufferToBuffer(out, out, prevOffset, common);
            if (commonLength < state.rowLength + 2) {
                int rowRestLength;
                int rowWithSizeLength;
                if (commonLength < 2) {
                    ByteBufferUtils.copyFromStreamToBuffer(out, source, 2 - commonLength);
                    rowWithSizeLength = out.getShort(out.position() - 2) + 2;
                    rowRestLength = rowWithSizeLength - 2;
                } else {
                    rowWithSizeLength = out.getShort(kvPos + 8) + 2;
                    rowRestLength = rowWithSizeLength - commonLength;
                }
                ByteBufferUtils.copyFromStreamToBuffer(out, source, rowRestLength);
                ByteBufferUtils.copyFromBufferToBuffer(out, out, state.prevOffset + 8 + 2 + state.rowLength, state.familyLength + 1);
                state.rowLength = (short)(rowWithSizeLength - 2);
                keyRestLength = state.keyLength - rowWithSizeLength - state.familyLength - 10;
            } else {
                keyRestLength = state.keyLength - commonLength - 9;
            }
            ByteBufferUtils.copyFromStreamToBuffer(out, source, keyRestLength);
            int prefixTimestamp = (flag & 7) >>> 0;
            ByteBufferUtils.copyFromBufferToBuffer(out, out, state.prevTimestampOffset, prefixTimestamp);
            state.prevTimestampOffset = out.position() - prefixTimestamp;
            ByteBufferUtils.copyFromStreamToBuffer(out, source, 8 - prefixTimestamp);
            if ((flag & 0x20) != 0) {
                out.put(state.type);
                if ((flag & 0x40) != 0) {
                    ByteBufferUtils.copyFromBufferToBuffer(out, out, state.prevOffset + 8 + prevKeyLength, state.valueLength);
                } else {
                    ByteBufferUtils.copyFromStreamToBuffer(out, source, state.valueLength);
                }
            } else {
                if ((flag & 0x40) != 0) {
                    ByteBufferUtils.copyFromStreamToBuffer(out, source, 1);
                    ByteBufferUtils.copyFromBufferToBuffer(out, out, state.prevOffset + 8 + prevKeyLength, state.valueLength);
                } else {
                    ByteBufferUtils.copyFromStreamToBuffer(out, source, state.valueLength + 1);
                }
                state.type = out.get(state.prevTimestampOffset + 8);
            }
        } else {
            state.decompressFirstKV(out, source);
        }
        state.prevOffset = kvPos;
    }

    @Override
    public void internalEncodeKeyValues(DataOutputStream out, ByteBuffer in, HFileBlockDefaultEncodingContext encodingCtx) throws IOException {
        in.rewind();
        ByteBufferUtils.putInt(out, in.limit());
        FastDiffCompressionState previousState = new FastDiffCompressionState();
        FastDiffCompressionState currentState = new FastDiffCompressionState();
        while (in.hasRemaining()) {
            this.compressSingleKeyValue(previousState, currentState, out, in);
            this.afterEncodingKeyValue(in, out, encodingCtx);
            FastDiffCompressionState tmp = previousState;
            previousState = currentState;
            currentState = tmp;
        }
    }

    @Override
    protected ByteBuffer internalDecodeKeyValues(DataInputStream source, int allocateHeaderLength, int skipLastBytes, HFileBlockDefaultDecodingContext decodingCtx) throws IOException {
        int decompressedSize = source.readInt();
        ByteBuffer buffer = ByteBuffer.allocate(decompressedSize + allocateHeaderLength);
        buffer.position(allocateHeaderLength);
        FastDiffCompressionState state = new FastDiffCompressionState();
        while (source.available() > skipLastBytes) {
            this.uncompressSingleKeyValue(source, buffer, state);
            this.afterDecodingKeyValue(source, buffer, decodingCtx);
        }
        if (source.available() != skipLastBytes) {
            throw new IllegalStateException("Read too much bytes.");
        }
        return buffer;
    }

    @Override
    public ByteBuffer getFirstKeyInBlock(ByteBuffer block) {
        block.mark();
        block.position(5);
        int keyLength = ByteBufferUtils.readCompressedInt(block);
        ByteBufferUtils.readCompressedInt(block);
        ByteBufferUtils.readCompressedInt(block);
        int pos = block.position();
        block.reset();
        return ByteBuffer.wrap(block.array(), block.arrayOffset() + pos, keyLength).slice();
    }

    public String toString() {
        return FastDiffDeltaEncoder.class.getSimpleName();
    }

    @Override
    public DataBlockEncoder.EncodedSeeker createSeeker(KeyValue.KVComparator comparator, HFileBlockDecodingContext decodingCtx) {
        return new BufferedDataBlockEncoder.BufferedEncodedSeeker<FastDiffSeekerState>(comparator, decodingCtx){

            private void decode(boolean isFirst) {
                byte flag = this.currentBuffer.get();
                if ((flag & 8) == 0) {
                    if (!isFirst) {
                        System.arraycopy(((FastDiffSeekerState)this.current).keyBuffer, ((FastDiffSeekerState)this.current).keyLength - ((FastDiffSeekerState)this.current).prevTimestampAndType.length, ((FastDiffSeekerState)this.current).prevTimestampAndType, 0, ((FastDiffSeekerState)this.current).prevTimestampAndType.length);
                    }
                    ((FastDiffSeekerState)this.current).keyLength = ByteBufferUtils.readCompressedInt(this.currentBuffer);
                }
                if ((flag & 0x10) == 0) {
                    ((FastDiffSeekerState)this.current).valueLength = ByteBufferUtils.readCompressedInt(this.currentBuffer);
                }
                ((FastDiffSeekerState)this.current).lastCommonPrefix = ByteBufferUtils.readCompressedInt(this.currentBuffer);
                ((FastDiffSeekerState)this.current).ensureSpaceForKey();
                if (isFirst) {
                    this.currentBuffer.get(((FastDiffSeekerState)this.current).keyBuffer, ((FastDiffSeekerState)this.current).lastCommonPrefix, ((FastDiffSeekerState)this.current).keyLength - ((FastDiffSeekerState)this.current).prevTimestampAndType.length);
                    ((FastDiffSeekerState)this.current).rowLengthWithSize = Bytes.toShort(((FastDiffSeekerState)this.current).keyBuffer, 0) + 2;
                    ((FastDiffSeekerState)this.current).familyLengthWithSize = ((FastDiffSeekerState)this.current).keyBuffer[((FastDiffSeekerState)this.current).rowLengthWithSize] + 1;
                } else if (((FastDiffSeekerState)this.current).lastCommonPrefix < 2) {
                    int oldRowLengthWithSize = ((FastDiffSeekerState)this.current).rowLengthWithSize;
                    this.currentBuffer.get(((FastDiffSeekerState)this.current).keyBuffer, ((FastDiffSeekerState)this.current).lastCommonPrefix, 2 - ((FastDiffSeekerState)this.current).lastCommonPrefix);
                    ((FastDiffSeekerState)this.current).rowLengthWithSize = Bytes.toShort(((FastDiffSeekerState)this.current).keyBuffer, 0) + 2;
                    System.arraycopy(((FastDiffSeekerState)this.current).keyBuffer, oldRowLengthWithSize, ((FastDiffSeekerState)this.current).keyBuffer, ((FastDiffSeekerState)this.current).rowLengthWithSize, ((FastDiffSeekerState)this.current).familyLengthWithSize);
                    this.currentBuffer.get(((FastDiffSeekerState)this.current).keyBuffer, 2, ((FastDiffSeekerState)this.current).rowLengthWithSize - 2);
                    this.currentBuffer.get(((FastDiffSeekerState)this.current).keyBuffer, ((FastDiffSeekerState)this.current).rowLengthWithSize + ((FastDiffSeekerState)this.current).familyLengthWithSize, ((FastDiffSeekerState)this.current).keyLength - ((FastDiffSeekerState)this.current).rowLengthWithSize - ((FastDiffSeekerState)this.current).familyLengthWithSize - ((FastDiffSeekerState)this.current).prevTimestampAndType.length);
                } else if (((FastDiffSeekerState)this.current).lastCommonPrefix < ((FastDiffSeekerState)this.current).rowLengthWithSize) {
                    this.currentBuffer.get(((FastDiffSeekerState)this.current).keyBuffer, ((FastDiffSeekerState)this.current).lastCommonPrefix, ((FastDiffSeekerState)this.current).rowLengthWithSize - ((FastDiffSeekerState)this.current).lastCommonPrefix);
                    this.currentBuffer.get(((FastDiffSeekerState)this.current).keyBuffer, ((FastDiffSeekerState)this.current).rowLengthWithSize + ((FastDiffSeekerState)this.current).familyLengthWithSize, ((FastDiffSeekerState)this.current).keyLength - ((FastDiffSeekerState)this.current).rowLengthWithSize - ((FastDiffSeekerState)this.current).familyLengthWithSize - ((FastDiffSeekerState)this.current).prevTimestampAndType.length);
                } else {
                    this.currentBuffer.get(((FastDiffSeekerState)this.current).keyBuffer, ((FastDiffSeekerState)this.current).lastCommonPrefix, ((FastDiffSeekerState)this.current).keyLength - ((FastDiffSeekerState)this.current).prevTimestampAndType.length - ((FastDiffSeekerState)this.current).lastCommonPrefix);
                }
                int pos = ((FastDiffSeekerState)this.current).keyLength - ((FastDiffSeekerState)this.current).prevTimestampAndType.length;
                int commonTimestampPrefix = (flag & 7) >>> 0;
                if ((flag & 8) == 0) {
                    System.arraycopy(((FastDiffSeekerState)this.current).prevTimestampAndType, 0, ((FastDiffSeekerState)this.current).keyBuffer, pos, commonTimestampPrefix);
                }
                this.currentBuffer.get(((FastDiffSeekerState)this.current).keyBuffer, pos += commonTimestampPrefix, 8 - commonTimestampPrefix);
                pos += 8 - commonTimestampPrefix;
                if ((flag & 0x20) == 0) {
                    this.currentBuffer.get(((FastDiffSeekerState)this.current).keyBuffer, pos, 1);
                } else if ((flag & 8) == 0) {
                    ((FastDiffSeekerState)this.current).keyBuffer[pos] = ((FastDiffSeekerState)this.current).prevTimestampAndType[8];
                }
                if ((flag & 0x40) == 0) {
                    ((FastDiffSeekerState)this.current).valueOffset = this.currentBuffer.position();
                    ByteBufferUtils.skip(this.currentBuffer, ((FastDiffSeekerState)this.current).valueLength);
                }
                if (this.includesTags()) {
                    this.decodeTags();
                }
                ((FastDiffSeekerState)this.current).memstoreTS = this.includesMvcc() ? ByteBufferUtils.readVLong(this.currentBuffer) : 0L;
                ((FastDiffSeekerState)this.current).nextKvOffset = this.currentBuffer.position();
            }

            @Override
            protected void decodeFirst() {
                ByteBufferUtils.skip(this.currentBuffer, 4);
                this.decode(true);
            }

            @Override
            protected void decodeNext() {
                this.decode(false);
            }

            @Override
            protected FastDiffSeekerState createSeekerState() {
                return new FastDiffSeekerState();
            }
        };
    }

    protected static class FastDiffSeekerState
    extends BufferedDataBlockEncoder.SeekerState {
        private byte[] prevTimestampAndType = new byte[9];
        private int rowLengthWithSize;
        private int familyLengthWithSize;

        protected FastDiffSeekerState() {
        }

        @Override
        protected void copyFromNext(BufferedDataBlockEncoder.SeekerState that) {
            super.copyFromNext(that);
            FastDiffSeekerState other = (FastDiffSeekerState)that;
            System.arraycopy(other.prevTimestampAndType, 0, this.prevTimestampAndType, 0, 9);
            this.rowLengthWithSize = other.rowLengthWithSize;
            this.familyLengthWithSize = other.familyLengthWithSize;
        }
    }

    private static class FastDiffCompressionState
    extends CompressionState {
        byte[] timestamp = new byte[8];
        int prevTimestampOffset;

        private FastDiffCompressionState() {
        }

        @Override
        protected void readTimestamp(ByteBuffer in) {
            in.get(this.timestamp);
        }

        @Override
        void copyFrom(CompressionState state) {
            super.copyFrom(state);
            FastDiffCompressionState state2 = (FastDiffCompressionState)state;
            System.arraycopy(state2.timestamp, 0, this.timestamp, 0, 8);
            this.prevTimestampOffset = state2.prevTimestampOffset;
        }

        private void decompressFirstKV(ByteBuffer out, DataInputStream in) throws IOException {
            int kvPos = out.position();
            out.putInt(this.keyLength);
            out.putInt(this.valueLength);
            this.prevTimestampOffset = out.position() + this.keyLength - 9;
            ByteBufferUtils.copyFromStreamToBuffer(out, in, this.keyLength + this.valueLength);
            this.rowLength = out.getShort(kvPos + 8);
            this.familyLength = out.get(kvPos + 8 + 2 + this.rowLength);
            this.type = out.get(this.prevTimestampOffset + 8);
        }
    }
}

