/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassFinder {
    private static final Log LOG = LogFactory.getLog(ClassFinder.class);
    private static String CLASS_EXT = ".class";
    private ResourcePathFilter resourcePathFilter;
    private FileNameFilter fileNameFilter;
    private ClassFilter classFilter;
    private FileFilter fileFilter;

    public ClassFinder() {
        this(null, null, null);
    }

    public ClassFinder(ResourcePathFilter resourcePathFilter, FileNameFilter fileNameFilter, ClassFilter classFilter) {
        this.resourcePathFilter = resourcePathFilter;
        this.classFilter = classFilter;
        this.fileNameFilter = fileNameFilter;
        this.fileFilter = new FileFilterWithName(fileNameFilter);
    }

    public Set<Class<?>> findClasses(boolean proceedOnExceptions) throws ClassNotFoundException, IOException, LinkageError {
        return this.findClasses(this.getClass().getPackage().getName(), proceedOnExceptions);
    }

    public Set<Class<?>> findClasses(String packageName, boolean proceedOnExceptions) throws ClassNotFoundException, IOException, LinkageError {
        String path = packageName.replace('.', '/');
        Pattern jarResourceRe = Pattern.compile("^file:(.+\\.jar)!/" + path + "$");
        Enumeration<URL> resources = ClassLoader.getSystemClassLoader().getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        ArrayList<String> jars = new ArrayList<String>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String resourcePath = resource.getFile();
            Matcher matcher = jarResourceRe.matcher(resourcePath);
            boolean isJar = matcher.find();
            String string = resourcePath = isJar ? matcher.group(1) : resourcePath;
            if (null != this.resourcePathFilter && !this.resourcePathFilter.isCandidatePath(resourcePath, isJar)) continue;
            LOG.debug((Object)("Will look for classes in " + resourcePath));
            if (isJar) {
                jars.add(resourcePath);
                continue;
            }
            dirs.add(new File(resourcePath));
        }
        HashSet classes = new HashSet();
        for (File directory : dirs) {
            classes.addAll(this.findClassesFromFiles(directory, packageName, proceedOnExceptions));
        }
        for (String jarFileName : jars) {
            classes.addAll(this.findClassesFromJar(jarFileName, packageName, proceedOnExceptions));
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Class<?>> findClassesFromJar(String jarFileName, String packageName, boolean proceedOnExceptions) throws IOException, ClassNotFoundException, LinkageError {
        JarInputStream jarFile = null;
        try {
            jarFile = new JarInputStream(new FileInputStream(jarFileName));
        }
        catch (IOException ioEx) {
            LOG.warn((Object)("Failed to look for classes in " + jarFileName + ": " + ioEx));
            throw ioEx;
        }
        HashSet classes = new HashSet();
        JarEntry entry = null;
        try {
            while (true) {
                Class<?> c;
                String fileName;
                try {
                    entry = jarFile.getNextJarEntry();
                }
                catch (IOException ioEx) {
                    if (!proceedOnExceptions) {
                        throw ioEx;
                    }
                    LOG.warn((Object)("Failed to get next entry from " + jarFileName + ": " + ioEx));
                    break;
                }
                if (entry == null) break;
                String className = entry.getName();
                if (!className.endsWith(CLASS_EXT)) continue;
                int ix = className.lastIndexOf(47);
                String string = fileName = ix >= 0 ? className.substring(ix + 1) : className;
                if (null != this.fileNameFilter && !this.fileNameFilter.isCandidateFile(fileName, className) || !(className = className.substring(0, className.length() - CLASS_EXT.length()).replace('/', '.')).startsWith(packageName) || (c = this.makeClass(className, proceedOnExceptions)) == null || classes.add(c)) continue;
                LOG.warn((Object)("Ignoring duplicate class " + className));
            }
            HashSet hashSet = classes;
            return hashSet;
        }
        finally {
            jarFile.close();
        }
    }

    private Set<Class<?>> findClassesFromFiles(File baseDirectory, String packageName, boolean proceedOnExceptions) throws ClassNotFoundException, LinkageError {
        HashSet classes = new HashSet();
        if (!baseDirectory.exists()) {
            LOG.warn((Object)("Failed to find " + baseDirectory.getAbsolutePath()));
            return classes;
        }
        File[] files = baseDirectory.listFiles(this.fileFilter);
        if (files == null) {
            LOG.warn((Object)("Failed to get files from " + baseDirectory.getAbsolutePath()));
            return classes;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (file.isDirectory()) {
                classes.addAll(this.findClassesFromFiles(file, packageName + "." + fileName, proceedOnExceptions));
                continue;
            }
            String className = packageName + '.' + fileName.substring(0, fileName.length() - CLASS_EXT.length());
            Class<?> c = this.makeClass(className, proceedOnExceptions);
            if (c == null || classes.add(c)) continue;
            LOG.warn((Object)("Ignoring duplicate class " + className));
        }
        return classes;
    }

    private Class<?> makeClass(String className, boolean proceedOnExceptions) throws ClassNotFoundException, LinkageError {
        try {
            Class<?> c = Class.forName(className, false, this.getClass().getClassLoader());
            boolean isCandidateClass = null == this.classFilter || this.classFilter.isCandidateClass(c);
            return isCandidateClass ? c : null;
        }
        catch (ClassNotFoundException classNotFoundEx) {
            if (!proceedOnExceptions) {
                throw classNotFoundEx;
            }
            LOG.debug((Object)("Failed to instantiate or check " + className + ": " + classNotFoundEx));
        }
        catch (LinkageError linkageEx) {
            if (!proceedOnExceptions) {
                throw linkageEx;
            }
            LOG.debug((Object)("Failed to instantiate or check " + className + ": " + linkageEx));
        }
        return null;
    }

    private class FileFilterWithName
    implements FileFilter {
        private FileNameFilter nameFilter;

        public FileFilterWithName(FileNameFilter nameFilter) {
            this.nameFilter = nameFilter;
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(CLASS_EXT) && (null == this.nameFilter || this.nameFilter.isCandidateFile(file.getName(), file.getAbsolutePath()));
        }
    }

    public static interface ClassFilter {
        public boolean isCandidateClass(Class<?> var1);
    }

    public static interface FileNameFilter {
        public boolean isCandidateFile(String var1, String var2);
    }

    public static interface ResourcePathFilter {
        public boolean isCandidatePath(String var1, boolean var2);
    }
}

