/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;

@XmlRootElement(name="node")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NodeInfo {
    protected String rack;
    protected NodeState state;
    protected String id;
    protected String nodeHostName;
    protected String nodeHTTPAddress;
    protected long lastHealthUpdate;
    protected String healthReport;
    protected int numContainers;
    protected long usedMemoryMB;
    protected long availMemoryMB;

    public NodeInfo() {
    }

    public NodeInfo(RMNode ni, ResourceScheduler sched) {
        NodeId id = ni.getNodeID();
        SchedulerNodeReport report = sched.getNodeReport(id);
        this.numContainers = 0;
        this.usedMemoryMB = 0L;
        this.availMemoryMB = 0L;
        if (report != null) {
            this.numContainers = report.getNumContainers();
            this.usedMemoryMB = report.getUsedResource().getMemory();
            this.availMemoryMB = report.getAvailableResource().getMemory();
        }
        this.id = id.toString();
        this.rack = ni.getRackName();
        this.nodeHostName = ni.getHostName();
        this.state = ni.getState();
        this.nodeHTTPAddress = ni.getHttpAddress();
        this.lastHealthUpdate = ni.getLastHealthReportTime();
        this.healthReport = String.valueOf(ni.getHealthReport());
    }

    public String getRack() {
        return this.rack;
    }

    public String getState() {
        return String.valueOf(this.state);
    }

    public String getNodeId() {
        return this.id;
    }

    public String getNodeHTTPAddress() {
        return this.nodeHTTPAddress;
    }

    public void setNodeHTTPAddress(String nodeHTTPAddress) {
        this.nodeHTTPAddress = nodeHTTPAddress;
    }

    public long getLastHealthUpdate() {
        return this.lastHealthUpdate;
    }

    public String getHealthReport() {
        return this.healthReport;
    }

    public int getNumContainers() {
        return this.numContainers;
    }

    public long getUsedMemory() {
        return this.usedMemoryMB;
    }

    public long getAvailableMemory() {
        return this.availMemoryMB;
    }
}

