/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.utils.Lock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

class CSQueueUtils {
    static final float EPSILON = 1.0E-4f;

    CSQueueUtils() {
    }

    public static void checkMaxCapacity(String queueName, float capacity, float maximumCapacity) {
        if (maximumCapacity < 0.0f || maximumCapacity > 1.0f) {
            throw new IllegalArgumentException("Illegal value  of maximumCapacity " + maximumCapacity + " used in call to setMaxCapacity for queue " + queueName);
        }
    }

    public static void checkAbsoluteCapacities(String queueName, float absCapacity, float absMaxCapacity) {
        if (absMaxCapacity < absCapacity - 1.0E-4f) {
            throw new IllegalArgumentException("Illegal call to setMaxCapacity. Queue '" + queueName + "' has " + "an absolute capacity (" + absCapacity + ") greater than " + "its absolute maximumCapacity (" + absMaxCapacity + ")");
        }
    }

    public static float computeAbsoluteMaximumCapacity(float maximumCapacity, CSQueue parent) {
        float parentAbsMaxCapacity = parent == null ? 1.0f : parent.getAbsoluteMaximumCapacity();
        return parentAbsMaxCapacity * maximumCapacity;
    }

    public static int computeMaxActiveApplications(ResourceCalculator calculator, Resource clusterResource, Resource minimumAllocation, float maxAMResourcePercent, float absoluteMaxCapacity) {
        return Math.max((int)Math.ceil(Resources.ratio((ResourceCalculator)calculator, (Resource)clusterResource, (Resource)minimumAllocation) * maxAMResourcePercent * absoluteMaxCapacity), 1);
    }

    public static int computeMaxActiveApplicationsPerUser(int maxActiveApplications, int userLimit, float userLimitFactor) {
        return Math.max((int)Math.ceil((float)maxActiveApplications * ((float)userLimit / 100.0f) * userLimitFactor), 1);
    }

    @Lock(value={CSQueue.class})
    public static void updateQueueStatistics(ResourceCalculator calculator, CSQueue childQueue, CSQueue parentQueue, Resource clusterResource, Resource minimumAllocation) {
        Resource queueLimit = Resources.none();
        Resource usedResources = childQueue.getUsedResources();
        float absoluteUsedCapacity = 0.0f;
        float usedCapacity = 0.0f;
        if (Resources.greaterThan((ResourceCalculator)calculator, (Resource)clusterResource, (Resource)clusterResource, (Resource)Resources.none())) {
            queueLimit = Resources.multiply((Resource)clusterResource, (double)childQueue.getAbsoluteCapacity());
            absoluteUsedCapacity = Resources.divide((ResourceCalculator)calculator, (Resource)clusterResource, (Resource)usedResources, (Resource)clusterResource);
            usedCapacity = Resources.equals((Resource)queueLimit, (Resource)Resources.none()) ? 0.0f : Resources.divide((ResourceCalculator)calculator, (Resource)clusterResource, (Resource)usedResources, (Resource)queueLimit);
        }
        childQueue.setUsedCapacity(usedCapacity);
        childQueue.setAbsoluteUsedCapacity(absoluteUsedCapacity);
        Resource available = Resources.subtract((Resource)queueLimit, (Resource)usedResources);
        childQueue.getMetrics().setAvailableResourcesToQueue(Resources.max((ResourceCalculator)calculator, (Resource)clusterResource, (Resource)available, (Resource)Resources.none()));
    }
}

