/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.utils.Lock;

@InterfaceAudience.Private
public class ActiveUsersManager {
    private static final Log LOG = LogFactory.getLog(ActiveUsersManager.class);
    private final QueueMetrics metrics;
    private int activeUsers = 0;
    private Map<String, Set<ApplicationId>> usersApplications = new HashMap<String, Set<ApplicationId>>();

    public ActiveUsersManager(QueueMetrics metrics) {
        this.metrics = metrics;
    }

    @Lock(value={Queue.class, SchedulerApplication.class})
    public synchronized void activateApplication(String user, ApplicationId applicationId) {
        Set<ApplicationId> userApps = this.usersApplications.get(user);
        if (userApps == null) {
            userApps = new HashSet<ApplicationId>();
            this.usersApplications.put(user, userApps);
            ++this.activeUsers;
            this.metrics.incrActiveUsers();
            LOG.debug((Object)("User " + user + " added to activeUsers, currently: " + this.activeUsers));
        }
        if (userApps.add(applicationId)) {
            this.metrics.activateApp(user);
        }
    }

    @Lock(value={Queue.class, SchedulerApplication.class})
    public synchronized void deactivateApplication(String user, ApplicationId applicationId) {
        Set<ApplicationId> userApps = this.usersApplications.get(user);
        if (userApps != null) {
            if (userApps.remove(applicationId)) {
                this.metrics.deactivateApp(user);
            }
            if (userApps.isEmpty()) {
                this.usersApplications.remove(user);
                --this.activeUsers;
                this.metrics.decrActiveUsers();
                LOG.debug((Object)("User " + user + " removed from activeUsers, currently: " + this.activeUsers));
            }
        }
    }

    @Lock(value={Queue.class, SchedulerApplication.class})
    public synchronized int getNumActiveUsers() {
        return this.activeUsers;
    }
}

