/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.LogAdapter;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.SignalLogger;
import org.apache.hadoop.util.VersionInfo;
import org.slf4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class StringUtils {
    public static final int SHUTDOWN_HOOK_PRIORITY = 0;
    public static final Pattern SHELL_ENV_VAR_PATTERN = Pattern.compile("\\$([A-Za-z_]{1}[A-Za-z0-9_]*)");
    public static final Pattern WIN_ENV_VAR_PATTERN = Pattern.compile("%(.*?)%");
    public static final Pattern ENV_VAR_PATTERN = Shell.WINDOWS ? WIN_ENV_VAR_PATTERN : SHELL_ENV_VAR_PATTERN;
    public static final String[] emptyStringArray = new String[0];
    public static final char COMMA = ',';
    public static final String COMMA_STR = ",";
    public static final char ESCAPE_CHAR = '\\';

    public static String stringifyException(Throwable e) {
        StringWriter stm = new StringWriter();
        PrintWriter wrt = new PrintWriter(stm);
        e.printStackTrace(wrt);
        wrt.close();
        return stm.toString();
    }

    public static String simpleHostname(String fullHostname) {
        if (InetAddresses.isInetAddress((String)fullHostname)) {
            return fullHostname;
        }
        int offset = fullHostname.indexOf(46);
        if (offset != -1) {
            return fullHostname.substring(0, offset);
        }
        return fullHostname;
    }

    @Deprecated
    public static String humanReadableInt(long number) {
        return TraditionalBinaryPrefix.long2String(number, "", 1);
    }

    public static String format(String format, Object ... objects) {
        return String.format(Locale.ENGLISH, format, objects);
    }

    public static String formatPercent(double fraction, int decimalPlaces) {
        return StringUtils.format("%." + decimalPlaces + "f%%", fraction * 100.0);
    }

    public static String arrayToString(String[] strs) {
        if (strs.length == 0) {
            return "";
        }
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(strs[0]);
        for (int idx = 1; idx < strs.length; ++idx) {
            sbuf.append(COMMA_STR);
            sbuf.append(strs[idx]);
        }
        return sbuf.toString();
    }

    public static String byteToHexString(byte[] bytes, int start, int end) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes == null");
        }
        StringBuilder s = new StringBuilder();
        for (int i = start; i < end; ++i) {
            s.append(StringUtils.format("%02x", bytes[i]));
        }
        return s.toString();
    }

    public static String byteToHexString(byte[] bytes) {
        return StringUtils.byteToHexString(bytes, 0, bytes.length);
    }

    public static byte[] hexStringToByte(String hex) {
        byte[] bts = new byte[hex.length() / 2];
        for (int i = 0; i < bts.length; ++i) {
            bts[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return bts;
    }

    public static String uriToString(URI[] uris) {
        if (uris == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder(uris[0].toString());
        for (int i = 1; i < uris.length; ++i) {
            ret.append(COMMA_STR);
            ret.append(uris[i].toString());
        }
        return ret.toString();
    }

    public static URI[] stringToURI(String[] str) {
        if (str == null) {
            return null;
        }
        URI[] uris = new URI[str.length];
        for (int i = 0; i < str.length; ++i) {
            try {
                uris[i] = new URI(str[i]);
                continue;
            }
            catch (URISyntaxException ur) {
                throw new IllegalArgumentException("Failed to create uri for " + str[i], ur);
            }
        }
        return uris;
    }

    public static Path[] stringToPath(String[] str) {
        if (str == null) {
            return null;
        }
        Path[] p = new Path[str.length];
        for (int i = 0; i < str.length; ++i) {
            p[i] = new Path(str[i]);
        }
        return p;
    }

    public static String formatTimeDiff(long finishTime, long startTime) {
        long timeDiff = finishTime - startTime;
        return StringUtils.formatTime(timeDiff);
    }

    public static String formatTime(long timeDiff) {
        StringBuilder buf = new StringBuilder();
        long hours = timeDiff / 3600000L;
        long rem = timeDiff % 3600000L;
        long minutes = rem / 60000L;
        long seconds = (rem %= 60000L) / 1000L;
        if (hours != 0L) {
            buf.append(hours);
            buf.append("hrs, ");
        }
        if (minutes != 0L) {
            buf.append(minutes);
            buf.append("mins, ");
        }
        buf.append(seconds);
        buf.append("sec");
        return buf.toString();
    }

    public static String getFormattedTimeWithDiff(DateFormat dateFormat, long finishTime, long startTime) {
        StringBuilder buf = new StringBuilder();
        if (0L != finishTime) {
            buf.append(dateFormat.format(new Date(finishTime)));
            if (0L != startTime) {
                buf.append(" (" + StringUtils.formatTimeDiff(finishTime, startTime) + ")");
            }
        }
        return buf.toString();
    }

    public static String[] getStrings(String str) {
        Collection<String> values = StringUtils.getStringCollection(str);
        if (values.size() == 0) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    public static Collection<String> getStringCollection(String str) {
        String delim = COMMA_STR;
        return StringUtils.getStringCollection(str, delim);
    }

    public static Collection<String> getStringCollection(String str, String delim) {
        ArrayList<String> values = new ArrayList<String>();
        if (str == null) {
            return values;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, delim);
        while (tokenizer.hasMoreTokens()) {
            values.add(tokenizer.nextToken());
        }
        return values;
    }

    public static Collection<String> getTrimmedStringCollection(String str) {
        LinkedHashSet<String> set = new LinkedHashSet<String>(Arrays.asList(StringUtils.getTrimmedStrings(str)));
        set.remove("");
        return set;
    }

    public static String[] getTrimmedStrings(String str) {
        if (null == str || str.trim().isEmpty()) {
            return emptyStringArray;
        }
        return str.trim().split("\\s*,\\s*");
    }

    public static Set<String> getTrimmedStrings(Collection<String> strings) {
        HashSet<String> trimmedStrings = new HashSet<String>();
        for (String string : strings) {
            trimmedStrings.add(string.trim());
        }
        return trimmedStrings;
    }

    public static String[] split(String str) {
        return StringUtils.split(str, '\\', ',');
    }

    public static String[] split(String str, char escapeChar, char separator) {
        if (str == null) {
            return null;
        }
        ArrayList<String> strList = new ArrayList<String>();
        StringBuilder split = new StringBuilder();
        int index = 0;
        while ((index = StringUtils.findNext(str, separator, escapeChar, index, split)) >= 0) {
            ++index;
            strList.add(split.toString());
            split.setLength(0);
        }
        strList.add(split.toString());
        int last = strList.size();
        while (--last >= 0 && "".equals(strList.get(last))) {
            strList.remove(last);
        }
        return strList.toArray(new String[strList.size()]);
    }

    public static String[] split(String str, char separator) {
        if (str.isEmpty()) {
            return new String[]{""};
        }
        ArrayList<String> strList = new ArrayList<String>();
        int startIndex = 0;
        int nextIndex = 0;
        while ((nextIndex = str.indexOf(separator, startIndex)) != -1) {
            strList.add(str.substring(startIndex, nextIndex));
            startIndex = nextIndex + 1;
        }
        strList.add(str.substring(startIndex));
        int last = strList.size();
        while (--last >= 0 && "".equals(strList.get(last))) {
            strList.remove(last);
        }
        return strList.toArray(new String[strList.size()]);
    }

    public static int findNext(String str, char separator, char escapeChar, int start, StringBuilder split) {
        int numPreEscapes = 0;
        for (int i = start; i < str.length(); ++i) {
            char curChar = str.charAt(i);
            if (numPreEscapes == 0 && curChar == separator) {
                return i;
            }
            split.append(curChar);
            numPreEscapes = curChar == escapeChar ? ++numPreEscapes % 2 : 0;
        }
        return -1;
    }

    public static String escapeString(String str) {
        return StringUtils.escapeString(str, '\\', ',');
    }

    public static String escapeString(String str, char escapeChar, char charToEscape) {
        return StringUtils.escapeString(str, escapeChar, new char[]{charToEscape});
    }

    private static boolean hasChar(char[] chars, char character) {
        for (char target : chars) {
            if (character != target) continue;
            return true;
        }
        return false;
    }

    public static String escapeString(String str, char escapeChar, char[] charsToEscape) {
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char curChar = str.charAt(i);
            if (curChar == escapeChar || StringUtils.hasChar(charsToEscape, curChar)) {
                result.append(escapeChar);
            }
            result.append(curChar);
        }
        return result.toString();
    }

    public static String unEscapeString(String str) {
        return StringUtils.unEscapeString(str, '\\', ',');
    }

    public static String unEscapeString(String str, char escapeChar, char charToEscape) {
        return StringUtils.unEscapeString(str, escapeChar, new char[]{charToEscape});
    }

    public static String unEscapeString(String str, char escapeChar, char[] charsToEscape) {
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(str.length());
        boolean hasPreEscape = false;
        for (int i = 0; i < str.length(); ++i) {
            char curChar = str.charAt(i);
            if (hasPreEscape) {
                if (curChar != escapeChar && !StringUtils.hasChar(charsToEscape, curChar)) {
                    throw new IllegalArgumentException("Illegal escaped string " + str + " unescaped " + escapeChar + " at " + (i - 1));
                }
                result.append(curChar);
                hasPreEscape = false;
                continue;
            }
            if (StringUtils.hasChar(charsToEscape, curChar)) {
                throw new IllegalArgumentException("Illegal escaped string " + str + " unescaped " + curChar + " at " + i);
            }
            if (curChar == escapeChar) {
                hasPreEscape = true;
                continue;
            }
            result.append(curChar);
        }
        if (hasPreEscape) {
            throw new IllegalArgumentException("Illegal escaped string " + str + ", not expecting " + escapeChar + " in the end.");
        }
        return result.toString();
    }

    private static String toStartupShutdownString(String prefix, String[] msg) {
        StringBuilder b = new StringBuilder(prefix);
        b.append("\n/************************************************************");
        for (String s : msg) {
            b.append("\n" + prefix + s);
        }
        b.append("\n************************************************************/");
        return b.toString();
    }

    public static void startupShutdownMessage(Class<?> clazz, String[] args, Log LOG) {
        StringUtils.startupShutdownMessage(clazz, args, LogAdapter.create(LOG));
    }

    public static void startupShutdownMessage(Class<?> clazz, String[] args, Logger LOG) {
        StringUtils.startupShutdownMessage(clazz, args, LogAdapter.create(LOG));
    }

    static void startupShutdownMessage(Class<?> clazz, String[] args, final LogAdapter LOG) {
        final String hostname = NetUtils.getHostname();
        final String classname = clazz.getSimpleName();
        LOG.info(StringUtils.toStartupShutdownString("STARTUP_MSG: ", new String[]{"Starting " + classname, "  host = " + hostname, "  args = " + Arrays.asList(args), "  version = " + VersionInfo.getVersion(), "  classpath = " + System.getProperty("java.class.path"), "  build = " + VersionInfo.getUrl() + " -r " + VersionInfo.getRevision() + "; compiled by '" + VersionInfo.getUser() + "' on " + VersionInfo.getDate(), "  java = " + System.getProperty("java.version")}));
        if (SystemUtils.IS_OS_UNIX) {
            try {
                SignalLogger.INSTANCE.register(LOG);
            }
            catch (Throwable t) {
                LOG.warn("failed to register any UNIX signal loggers: ", t);
            }
        }
        ShutdownHookManager.get().addShutdownHook(new Runnable(){

            @Override
            public void run() {
                LOG.info(StringUtils.toStartupShutdownString("SHUTDOWN_MSG: ", new String[]{"Shutting down " + classname + " at " + hostname}));
            }
        }, 0);
    }

    public static String escapeHTML(String string) {
        char[] chars;
        if (string == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean lastCharacterWasSpace = false;
        block6: for (char c : chars = string.toCharArray()) {
            if (c == ' ') {
                if (lastCharacterWasSpace) {
                    lastCharacterWasSpace = false;
                    sb.append("&nbsp;");
                    continue;
                }
                lastCharacterWasSpace = true;
                sb.append(" ");
                continue;
            }
            lastCharacterWasSpace = false;
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String byteDesc(long len) {
        return TraditionalBinaryPrefix.long2String(len, "B", 2);
    }

    @Deprecated
    public static String limitDecimalTo2(double d) {
        return StringUtils.format("%.2f", d);
    }

    public static String join(CharSequence separator, Iterable<?> strings) {
        Iterator<?> i = strings.iterator();
        if (!i.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(i.next().toString());
        while (i.hasNext()) {
            sb.append(separator);
            sb.append(i.next().toString());
        }
        return sb.toString();
    }

    public static String join(CharSequence separator, String[] strings) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : strings) {
            if (first) {
                first = false;
            } else {
                sb.append(separator);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String camelize(String s) {
        String[] words;
        StringBuilder sb = new StringBuilder();
        for (String word : words = StringUtils.split(StringUtils.toLowerCase(s), '\\', '_')) {
            sb.append(org.apache.commons.lang.StringUtils.capitalize((String)word));
        }
        return sb.toString();
    }

    public static String replaceTokens(String template, Pattern pattern, Map<String, String> replacements) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = pattern.matcher(template);
        while (matcher.find()) {
            String replacement = replacements.get(matcher.group(1));
            if (replacement == null) {
                replacement = "";
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String getStackTrace(Thread t) {
        StackTraceElement[] stackTrace = t.getStackTrace();
        StringBuilder str = new StringBuilder();
        for (StackTraceElement e : stackTrace) {
            str.append(e.toString() + "\n");
        }
        return str.toString();
    }

    public static String popOptionWithArgument(String name, List<String> args) throws IllegalArgumentException {
        String cur;
        String val = null;
        Iterator<String> iter = args.iterator();
        while (iter.hasNext() && !(cur = iter.next()).equals("--")) {
            if (!cur.equals(name)) continue;
            iter.remove();
            if (!iter.hasNext()) {
                throw new IllegalArgumentException("option " + name + " requires 1 " + "argument.");
            }
            val = iter.next();
            iter.remove();
            break;
        }
        return val;
    }

    public static boolean popOption(String name, List<String> args) {
        String cur;
        Iterator<String> iter = args.iterator();
        while (iter.hasNext() && !(cur = iter.next()).equals("--")) {
            if (!cur.equals(name)) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    public static String popFirstNonOption(List<String> args) {
        Iterator<String> iter = args.iterator();
        while (iter.hasNext()) {
            String cur = iter.next();
            if (cur.equals("--")) {
                if (!iter.hasNext()) {
                    return null;
                }
                cur = iter.next();
                iter.remove();
                return cur;
            }
            if (cur.startsWith("-")) continue;
            iter.remove();
            return cur;
        }
        return null;
    }

    public static String toLowerCase(String str) {
        return str.toLowerCase(Locale.ENGLISH);
    }

    public static String toUpperCase(String str) {
        return str.toUpperCase(Locale.ENGLISH);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        Preconditions.checkNotNull((Object)s1);
        return s1.equalsIgnoreCase(s2);
    }

    public static enum TraditionalBinaryPrefix {
        KILO(10),
        MEGA(TraditionalBinaryPrefix.KILO.bitShift + 10),
        GIGA(TraditionalBinaryPrefix.MEGA.bitShift + 10),
        TERA(TraditionalBinaryPrefix.GIGA.bitShift + 10),
        PETA(TraditionalBinaryPrefix.TERA.bitShift + 10),
        EXA(TraditionalBinaryPrefix.PETA.bitShift + 10);

        public final long value;
        public final char symbol;
        public final int bitShift;
        public final long bitMask;

        private TraditionalBinaryPrefix(int bitShift) {
            this.bitShift = bitShift;
            this.value = 1L << bitShift;
            this.bitMask = this.value - 1L;
            this.symbol = this.toString().charAt(0);
        }

        public static TraditionalBinaryPrefix valueOf(char symbol) {
            symbol = Character.toUpperCase(symbol);
            for (TraditionalBinaryPrefix prefix : TraditionalBinaryPrefix.values()) {
                if (symbol != prefix.symbol) continue;
                return prefix;
            }
            throw new IllegalArgumentException("Unknown symbol '" + symbol + "'");
        }

        public static long string2long(String s) {
            long prefix;
            int lastpos;
            char lastchar = (s = s.trim()).charAt(lastpos = s.length() - 1);
            if (Character.isDigit(lastchar)) {
                return Long.parseLong(s);
            }
            try {
                prefix = TraditionalBinaryPrefix.valueOf((char)lastchar).value;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid size prefix '" + lastchar + "' in '" + s + "'. Allowed prefixes are k, m, g, t, p, e(case insensitive)");
            }
            long num = Long.parseLong(s.substring(0, lastpos));
            if (num > Long.MAX_VALUE / prefix || num < Long.MIN_VALUE / prefix) {
                throw new IllegalArgumentException(s + " does not fit in a Long");
            }
            return num * prefix;
        }

        public static String long2String(long n, String unit, int decimalPlaces) {
            int i;
            if (unit == null) {
                unit = "";
            }
            if (n == Long.MIN_VALUE) {
                return "-8 " + TraditionalBinaryPrefix.EXA.symbol + unit;
            }
            StringBuilder b = new StringBuilder();
            if (n < 0L) {
                b.append('-');
                n = -n;
            }
            if (n < TraditionalBinaryPrefix.KILO.value) {
                b.append(n);
                return (unit.isEmpty() ? b : b.append(" ").append(unit)).toString();
            }
            for (i = 0; i < TraditionalBinaryPrefix.values().length && n >= TraditionalBinaryPrefix.values()[i].value; ++i) {
            }
            TraditionalBinaryPrefix prefix = TraditionalBinaryPrefix.values()[i - 1];
            if ((n & prefix.bitMask) == 0L) {
                b.append(n >> prefix.bitShift);
            } else {
                String format = "%." + decimalPlaces + "f";
                String s = StringUtils.format(format, (double)n / (double)prefix.value);
                if (s.startsWith("1024")) {
                    prefix = TraditionalBinaryPrefix.values()[i];
                    s = StringUtils.format(format, (double)n / (double)prefix.value);
                }
                b.append(s);
            }
            return b.append(' ').append(prefix.symbol).append(unit).toString();
        }
    }
}

