/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.apache.openejb.jee;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * The around-invoke type specifies a method on a
 * class to be called during the around invoke portion of an
 * ejb invocation.  Note that each class may have only one
 * around invoke method and that the method may not be
 * overloaded.
 * <p/>
 * If the around-invoke element is missing then
 * the class defining the callback is assumed to be the
 * interceptor class or component class in scope at the
 * location in the descriptor in which the around invoke
 * definition appears.
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "around-invokeType", propOrder = {
        "clazz",
        "methodName"
        })
public class AroundInvoke implements CallbackMethod{

    @XmlElement(name = "class")
    protected String clazz;
    @XmlElement(name = "method-name", required = true)
    protected String methodName;

    public AroundInvoke() {
    }

    public AroundInvoke(java.lang.reflect.Method method) {
        this(method.getDeclaringClass().getName(), method.getName());
    }

    public AroundInvoke(String clazz, String methodName) {
        this.clazz = clazz;
        this.methodName = methodName;
    }

    public String getClazz() {
        return clazz;
    }

    public void setClazz(String value) {
        this.clazz = value;
    }

    public String getMethodName() {
        return methodName;
    }

    public void setMethodName(String value) {
        this.methodName = value;
    }

    public String getClassName() {
        return getClazz();
    }
}
