/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.client.ClusterMetaData;
import org.apache.openejb.client.ClusterRequest;
import org.apache.openejb.client.ClusterResponse;
import org.apache.openejb.client.Connection;
import org.apache.openejb.client.ConnectionManager;
import org.apache.openejb.client.EjbObjectInputStream;
import org.apache.openejb.client.Exceptions;
import org.apache.openejb.client.ProtocolMetaData;
import org.apache.openejb.client.RemoteFailoverException;
import org.apache.openejb.client.Request;
import org.apache.openejb.client.Response;
import org.apache.openejb.client.ServerMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client {
    private static final Logger logger = Logger.getLogger("OpenEJB.client");
    public static final ThreadLocal<Set<URI>> failed = new ThreadLocal();
    private static final ProtocolMetaData PROTOCOL_VERSION = new ProtocolMetaData("3.1");
    private static Client client = new Client();
    private boolean retry = false;
    private static final Map<ServerMetaData, ClusterMetaData> clusters = new ConcurrentHashMap<ServerMetaData, ClusterMetaData>();

    public Client() {
        String retryValue = System.getProperty("openejb.client.requestretry", this.retry + "");
        this.retry = new Boolean(retryValue);
    }

    public static void setClient(Client client) {
        Client.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response request(Request req, Response res, ServerMetaData server) throws RemoteException {
        try {
            Response response = client.processRequest(req, res, server);
            return response;
        }
        finally {
            failed.remove();
        }
    }

    protected Response processRequest(Request req, Response res, ServerMetaData server) throws RemoteException {
        block55: {
            if (server == null) {
                throw new IllegalArgumentException("Server instance cannot be null");
            }
            ClusterMetaData cluster = Client.getClusterMetaData(server);
            Connection conn = null;
            try {
                conn = ConnectionManager.getConnection(cluster, server, req);
            }
            catch (IOException e) {
                throw new RemoteException("Unable to connect", e);
            }
            try {
                EjbObjectInputStream objectIn;
                InputStream in;
                ObjectOutputStream objectOut;
                OutputStream out;
                try {
                    out = conn.getOuputStream();
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot open output stream to server: ", e);
                }
                try {
                    PROTOCOL_VERSION.writeExternal(out);
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot write the protocol metadata to the server: ", e);
                }
                try {
                    objectOut = new ObjectOutputStream(out);
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot open object output stream to server: ", e);
                }
                try {
                    server.writeExternal(objectOut);
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot write the ServerMetaData to the server: ", e);
                }
                try {
                    ClusterRequest clusterRequest = new ClusterRequest(cluster);
                    objectOut.write(clusterRequest.getRequestType());
                    clusterRequest.writeExternal(objectOut);
                }
                catch (Throwable e) {
                    throw Exceptions.newIOException("Cannot write the ClusterMetaData to the server: ", e);
                }
                try {
                    objectOut.write(req.getRequestType());
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot write the request type to the server: ", e);
                }
                try {
                    req.writeExternal(objectOut);
                    objectOut.flush();
                    out.flush();
                }
                catch (NotSerializableException e) {
                    throw new IllegalArgumentException("Object is not serializable: " + e.getMessage());
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot write the request to the server: ", e);
                }
                try {
                    in = conn.getInputStream();
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot open input stream to server: ", e);
                }
                ProtocolMetaData protocolMetaData = null;
                try {
                    protocolMetaData = new ProtocolMetaData();
                    protocolMetaData.readExternal(in);
                }
                catch (EOFException e) {
                    throw Exceptions.newIOException("Prematurely reached the end of the stream.  " + protocolMetaData.getSpec(), e);
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot deternmine server protocol version: Received " + protocolMetaData.getSpec(), e);
                }
                try {
                    objectIn = new EjbObjectInputStream(in);
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot open object input stream to server (" + protocolMetaData.getSpec() + ") : " + e.getMessage(), e);
                }
                try {
                    ClusterResponse clusterResponse = new ClusterResponse();
                    clusterResponse.readExternal(objectIn);
                    switch (clusterResponse.getResponseCode()) {
                        case UPDATE: {
                            Client.setClusterMetaData(server, clusterResponse.getUpdatedMetaData());
                            break;
                        }
                        case FAILURE: {
                            throw clusterResponse.getFailure();
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RemoteException("Cannot read the response from the server.  The class for an object being returned is not located in this system:", e);
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot read the response from the server (" + protocolMetaData.getSpec() + ") : " + e.getMessage(), e);
                }
                catch (Throwable e) {
                    throw new RemoteException("Error reading response from server (" + protocolMetaData.getSpec() + ") : " + e.getMessage(), e);
                }
                try {
                    res.readExternal(objectIn);
                }
                catch (ClassNotFoundException e) {
                    throw new RemoteException("Cannot read the response from the server.  The class for an object being returned is not located in this system:", e);
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot read the response from the server (" + protocolMetaData.getSpec() + ") : " + e.getMessage(), e);
                }
                catch (Throwable e) {
                    throw new RemoteException("Error reading response from server (" + protocolMetaData.getSpec() + ") : " + e.getMessage(), e);
                }
            }
            catch (RemoteException e) {
                throw e;
            }
            catch (IOException e) {
                Set<URI> failed = Client.getFailed();
                failed.add(conn.getURI());
                conn.discard();
                if (!this.retry) break block55;
                try {
                    this.processRequest(req, res, server);
                }
                catch (RemoteFailoverException re) {
                    throw re;
                }
                catch (RemoteException re) {
                    throw new RemoteFailoverException("Cannot complete request.  Retry attempted on " + failed.size() + " servers", e);
                }
            }
            catch (Throwable error) {
                throw new RemoteException("Error while communicating with server: ", error);
            }
            finally {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, "Error closing connection with server: " + t.getMessage(), t);
                }
            }
        }
        return res;
    }

    public static Set<URI> getFailed() {
        Set<URI> set = failed.get();
        if (set == null) {
            set = new HashSet<URI>();
            failed.set(set);
        }
        return set;
    }

    private static void setClusterMetaData(ServerMetaData server, ClusterMetaData cluster) {
        clusters.put(server, cluster);
    }

    private static ClusterMetaData getClusterMetaData(ServerMetaData server) {
        ClusterMetaData cluster = clusters.get(server);
        if (cluster == null) {
            cluster = new ClusterMetaData(0L, server.getLocation());
            clusters.put(server, cluster);
        }
        return cluster;
    }
}

