/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.WeakHashMap;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;

public class PersistenceProviderResolverHolder {
    private static PersistenceProviderResolver persistenceResolver = new DefaultPersistenceProviderResolver();

    public static PersistenceProviderResolver getPersistenceProviderResolver() {
        return persistenceResolver;
    }

    public static void setPersistenceProviderResolver(PersistenceProviderResolver resolver) {
        if (persistenceResolver != null) {
            persistenceResolver.clearCachedProviders();
            persistenceResolver = null;
        }
        persistenceResolver = resolver != null ? resolver : new DefaultPersistenceProviderResolver();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultPersistenceProviderResolver
    implements PersistenceProviderResolver {
        private static final String SERVICES_FILENAME = "META-INF/services/" + PersistenceProvider.class.getName();
        private volatile WeakHashMap<ClassLoader, List<PersistenceProvider>> providerCache = new WeakHashMap();

        private DefaultPersistenceProviderResolver() {
        }

        @Override
        public List<PersistenceProvider> getPersistenceProviders() {
            List<PersistenceProvider> providers;
            ClassLoader cl = PrivClassLoader.get(null);
            if (cl == null) {
                cl = PrivClassLoader.get(DefaultPersistenceProviderResolver.class);
            }
            if ((providers = this.providerCache.get(cl)) == null) {
                providers = new ArrayList<PersistenceProvider>();
                try {
                    Enumeration<URL> cfgs = cl.getResources(SERVICES_FILENAME);
                    while (cfgs.hasMoreElements()) {
                        URL url = cfgs.nextElement();
                        InputStream is = null;
                        try {
                            is = url.openStream();
                            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"), 256);
                            String line = br.readLine();
                            while (line != null) {
                                if (!(line = line.trim()).startsWith("#")) {
                                    try {
                                        Class<?> provider = cl.loadClass(line);
                                        providers.add((PersistenceProvider)provider.newInstance());
                                    }
                                    catch (ClassNotFoundException e) {
                                        throw new PersistenceException("Failed to load provider " + line + " configured in file " + url, e);
                                    }
                                    catch (InstantiationException e) {
                                        throw new PersistenceException("Failed to instantiate provider " + line + " configured in file " + url, e);
                                    }
                                    catch (IllegalAccessException e) {
                                        throw new PersistenceException("Failed to access provider " + line + " configured in file " + url, e);
                                    }
                                }
                                line = br.readLine();
                            }
                            is.close();
                            is = null;
                        }
                        catch (IOException e) {
                            throw new PersistenceException("Error trying to read " + url, e);
                        }
                        finally {
                            if (is == null) continue;
                            is.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new PersistenceException("Error trying to load " + SERVICES_FILENAME, e);
                }
                this.providerCache.put(cl, providers);
            }
            return providers;
        }

        @Override
        public void clearCachedProviders() {
            this.providerCache.clear();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class PrivClassLoader
        implements PrivilegedAction<ClassLoader> {
            private final Class<?> c;

            public static ClassLoader get(Class<?> c) {
                PrivClassLoader action = new PrivClassLoader(c);
                if (System.getSecurityManager() != null) {
                    return AccessController.doPrivileged(action);
                }
                return action.run();
            }

            private PrivClassLoader(Class<?> c) {
                this.c = c;
            }

            @Override
            public ClassLoader run() {
                if (this.c != null) {
                    return this.c.getClassLoader();
                }
                return Thread.currentThread().getContextClassLoader();
            }
        }
    }
}

