/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.tags.cl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.felix.scrplugin.JavaClassDescriptorManager;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.om.Component;
import org.apache.felix.scrplugin.tags.JavaClassDescription;
import org.apache.felix.scrplugin.tags.JavaField;
import org.apache.felix.scrplugin.tags.JavaMethod;
import org.apache.felix.scrplugin.tags.JavaTag;
import org.apache.felix.scrplugin.tags.cl.ClassLoaderJavaField;
import org.apache.felix.scrplugin.tags.cl.ClassLoaderJavaMethod;
import org.apache.felix.scrplugin.tags.cl.ClassLoaderJavaTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderJavaClassDescription
implements JavaClassDescription {
    protected static final JavaTag[] EMPTY_TAGS = new JavaTag[0];
    protected final Class<?> clazz;
    protected final JavaClassDescriptorManager manager;
    protected final Component component;

    public ClassLoaderJavaClassDescription(Class<?> c, Component comp, JavaClassDescriptorManager m) {
        this.clazz = c;
        this.manager = m;
        this.component = comp;
    }

    @Override
    public JavaField[] getFields() {
        Field[] fields = this.clazz.getFields();
        JavaField[] javaFields = new JavaField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            javaFields[i] = new ClassLoaderJavaField(fields[i], this);
        }
        return javaFields;
    }

    @Override
    public JavaField getFieldByName(String name) throws SCRDescriptorException {
        Field field = null;
        try {
            field = this.clazz.getField(name);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (field != null) {
            return new ClassLoaderJavaField(field, this);
        }
        if (this.getSuperClass() != null) {
            this.getSuperClass().getFieldByName(name);
        }
        return null;
    }

    @Override
    public JavaField getExternalFieldByName(String name) throws SCRDescriptorException {
        throw new SCRDescriptorException("getExternalFieldByName not supported for this class.", this.getName(), 0);
    }

    @Override
    public JavaClassDescription getReferencedClass(String referencedName) throws SCRDescriptorException {
        throw new SCRDescriptorException("getReferencedClass not supported for this class.", this.getName(), 0);
    }

    @Override
    public JavaClassDescription[] getImplementedInterfaces() throws SCRDescriptorException {
        Class<?>[] implemented = this.clazz.getInterfaces();
        if (implemented.length == 0) {
            return JavaClassDescription.EMPTY_RESULT;
        }
        JavaClassDescription[] jcd = new JavaClassDescription[implemented.length];
        for (int i = 0; i < jcd.length; ++i) {
            jcd[i] = this.manager.getJavaClassDescription(implemented[i].getName());
        }
        return jcd;
    }

    @Override
    public JavaMethod getMethodBySignature(String name, String[] parameters) throws SCRDescriptorException {
        Class[] classParameters = null;
        if (parameters != null) {
            classParameters = new Class[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                try {
                    classParameters[i] = this.manager.getClassLoader().loadClass(parameters[i]);
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    return null;
                }
            }
        }
        Method m = null;
        try {
            m = this.clazz.getDeclaredMethod(name, classParameters);
        }
        catch (NoClassDefFoundError ncdfe) {
            throw new SCRDescriptorException("Class loading error. This error usually occurs if you have a service inheriting from a class coming from another bundle and that class using a third library and all dependencies are specified with scope 'provided'.", this.getName(), 0, ncdfe);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (m != null) {
            return new ClassLoaderJavaMethod(m);
        }
        if (this.getSuperClass() != null) {
            return this.getSuperClass().getMethodBySignature(name, parameters);
        }
        return null;
    }

    @Override
    public JavaMethod[] getMethods() {
        return JavaMethod.EMPTY_RESULT;
    }

    @Override
    public String getName() {
        return this.clazz.getName();
    }

    @Override
    public JavaClassDescription getSuperClass() throws SCRDescriptorException {
        if (this.clazz.getSuperclass() != null) {
            return this.manager.getJavaClassDescription(this.clazz.getSuperclass().getName());
        }
        return null;
    }

    @Override
    public JavaTag getTagByName(String name) {
        return null;
    }

    @Override
    public JavaTag[] getTagsByName(String name, boolean inherited) throws SCRDescriptorException {
        JavaTag[] superTags;
        JavaTag[] javaTags = EMPTY_TAGS;
        if (this.component != null) {
            int i;
            if ("scr.service".equals(name)) {
                if (this.component.getService() != null && this.component.getService().getInterfaces().size() > 0) {
                    javaTags = new JavaTag[this.component.getService().getInterfaces().size()];
                    for (i = 0; i < this.component.getService().getInterfaces().size(); ++i) {
                        javaTags[i] = new ClassLoaderJavaTag(this, this.component.getService().getInterfaces().get(i), this.component.getService().isServicefactory());
                    }
                }
            } else if ("scr.property".equals(name)) {
                if (this.component.getProperties().size() > 0) {
                    javaTags = new JavaTag[this.component.getProperties().size()];
                    for (i = 0; i < this.component.getProperties().size(); ++i) {
                        javaTags[i] = new ClassLoaderJavaTag((JavaClassDescription)this, this.component.getProperties().get(i));
                    }
                }
            } else if ("scr.reference".equals(name) && this.component.getReferences().size() > 0) {
                javaTags = new JavaTag[this.component.getReferences().size()];
                for (i = 0; i < this.component.getReferences().size(); ++i) {
                    javaTags[i] = new ClassLoaderJavaTag((JavaClassDescription)this, this.component.getReferences().get(i));
                }
            }
        }
        if (inherited && this.getSuperClass() != null && (superTags = this.getSuperClass().getTagsByName(name, inherited)).length > 0) {
            ArrayList<JavaTag> list = new ArrayList<JavaTag>(Arrays.asList(javaTags));
            list.addAll(Arrays.asList(superTags));
            javaTags = list.toArray(new JavaTag[list.size()]);
        }
        return javaTags;
    }

    @Override
    public boolean isA(String type) {
        if (this.clazz.getName().equals(type)) {
            return true;
        }
        return this.testClass(this.clazz, type);
    }

    protected boolean testClass(Class<?> c, String type) {
        Class<?>[] interfaces = c.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i].getName().equals(type)) {
                return true;
            }
            if (!this.testClass(interfaces[i], type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.clazz.getModifiers());
    }

    @Override
    public boolean isInterface() {
        return Modifier.isInterface(this.clazz.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.clazz.getModifiers());
    }

    public String toString() {
        return this.getName();
    }
}

