/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin;

import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scrplugin.Log;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.SCRDescriptorFailureException;
import org.apache.felix.scrplugin.om.Component;
import org.apache.felix.scrplugin.om.Components;
import org.apache.felix.scrplugin.tags.ClassUtil;
import org.apache.felix.scrplugin.tags.JavaClassDescription;
import org.apache.felix.scrplugin.tags.annotation.AnnotationJavaClassDescription;
import org.apache.felix.scrplugin.tags.annotation.AnnotationTagProviderManager;
import org.apache.felix.scrplugin.tags.cl.ClassLoaderJavaClassDescription;
import org.apache.felix.scrplugin.tags.qdox.QDoxJavaClassDescription;
import org.apache.felix.scrplugin.xml.ComponentDescriptorIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaClassDescriptorManager {
    protected final Log log;
    private final ClassLoader classloader;
    private final Map<String, JavaClassDescription> javaClassDescriptions = new HashMap<String, JavaClassDescription>();
    private final AnnotationTagProviderManager annotationTagProviderManager;
    private final boolean parseJavadocs;
    private final boolean processAnnotations;

    public JavaClassDescriptorManager(Log log, ClassLoader classLoader, String[] annotationTagProviders, boolean parseJavadocs, boolean processAnnotations) throws SCRDescriptorFailureException {
        this.processAnnotations = processAnnotations;
        this.parseJavadocs = parseJavadocs;
        this.log = log;
        this.annotationTagProviderManager = new AnnotationTagProviderManager(annotationTagProviders);
        ClassUtil.classLoader = this.classloader = classLoader;
    }

    protected abstract JavaSource[] getSources() throws SCRDescriptorException;

    protected abstract Map<String, Component> getComponentDescriptors() throws SCRDescriptorException;

    public abstract String getOutputDirectory();

    public Log getLog() {
        return this.log;
    }

    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    public AnnotationTagProviderManager getAnnotationTagProviderManager() {
        return this.annotationTagProviderManager;
    }

    public boolean isParseJavadocs() {
        return this.parseJavadocs;
    }

    public boolean isProcessAnnotations() {
        return this.processAnnotations;
    }

    protected Components parseServiceComponentDescriptor(InputStream file) throws SCRDescriptorException {
        return ComponentDescriptorIO.read(file);
    }

    public JavaClassDescription[] getSourceDescriptions() throws SCRDescriptorException {
        JavaClass[] javaClasses = this.getJavaClassesFromSources();
        JavaClassDescription[] descs = new JavaClassDescription[javaClasses.length];
        for (int i = 0; i < javaClasses.length; ++i) {
            descs[i] = this.getJavaClassDescription(javaClasses[i].getFullyQualifiedName());
        }
        return descs;
    }

    public JavaClassDescription getJavaClassDescription(String className) throws SCRDescriptorException {
        JavaClassDescription result = this.javaClassDescriptions.get(className);
        if (result == null) {
            this.log.debug("Searching description for: " + className);
            int index = 0;
            JavaClass[] javaClasses = this.getJavaClassesFromSources();
            while (result == null && index < javaClasses.length) {
                JavaClass javaClass = javaClasses[index];
                if (javaClass.getFullyQualifiedName().equals(className)) {
                    try {
                        Class<?> clazz = this.classloader.loadClass(className);
                        if (this.processAnnotations && this.getAnnotationTagProviderManager().hasScrPluginAnnotation(javaClass)) {
                            this.log.debug("Found java annotation description for: " + className);
                            result = new AnnotationJavaClassDescription(clazz, javaClasses[index], this);
                            continue;
                        }
                        if (!this.parseJavadocs) continue;
                        this.log.debug("Found qdox description for: " + className);
                        result = new QDoxJavaClassDescription(clazz, javaClasses[index], this);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new SCRDescriptorException("Unable to load class", className, 0);
                    }
                }
                ++index;
            }
            if (result == null) {
                try {
                    this.log.debug("Generating classloader description for: " + className);
                    result = new ClassLoaderJavaClassDescription(this.classloader.loadClass(className), this.getComponentDescriptors().get(className), this);
                }
                catch (ClassNotFoundException e) {
                    throw new SCRDescriptorException("Unable to load class", className, 0);
                }
            }
            this.javaClassDescriptions.put(className, result);
        }
        return result;
    }

    private JavaClass[] getJavaClassesFromSources() throws SCRDescriptorException {
        JavaSource[] sources = this.getSources();
        ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
        for (int i = 0; i < sources.length; ++i) {
            for (int j = 0; j < sources[i].getClasses().length; ++j) {
                JavaClass clazz = sources[i].getClasses()[j];
                classes.add(clazz);
                for (int k = 0; k < clazz.getNestedClasses().length; ++k) {
                    JavaClass nestedClass = clazz.getNestedClasses()[k];
                    classes.add(nestedClass);
                }
            }
        }
        return classes.toArray(new JavaClass[classes.size()]);
    }
}

