/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obrplugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.felix.obrplugin.ObrUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Mojo(name="clean", requiresProject=false, defaultPhase=LifecyclePhase.CLEAN)
public class ObrCleanRepo
extends AbstractMojo {
    @Parameter(property="obrRepository")
    private String obrRepository;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;

    public void execute() {
        if ("NONE".equalsIgnoreCase(this.obrRepository) || "false".equalsIgnoreCase(this.obrRepository)) {
            this.getLog().info((CharSequence)"Local OBR clean disabled (enable with -DobrRepository)");
            return;
        }
        try {
            URI repositoryXml = ObrUtils.findRepositoryXml(this.localRepository.getBasedir(), this.obrRepository);
            if (!"file".equals(repositoryXml.getScheme())) {
                this.getLog().error((CharSequence)("The repository URI " + repositoryXml + " is not a local file"));
                return;
            }
            File repositoryFile = new File(repositoryXml);
            if (!repositoryFile.exists()) {
                this.getLog().error((CharSequence)("The repository file " + repositoryFile + " does not exist"));
                return;
            }
            this.getLog().info((CharSequence)"Cleaning...");
            Document doc = this.parseFile(repositoryFile, this.initConstructor());
            Element finalDocument = this.cleanDocument(doc.getDocumentElement());
            if (finalDocument == null) {
                this.getLog().info((CharSequence)("Nothing to clean in " + repositoryFile));
            } else {
                this.writeToFile(repositoryXml, finalDocument);
                this.getLog().info((CharSequence)("Repository " + repositoryFile + " cleaned"));
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Exception while cleaning local OBR: " + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private Element cleanDocument(Element elem) {
        String localRepoPath = this.localRepository.getBasedir();
        URI baseURI = new File(localRepoPath + '/').toURI();
        NodeList nodes = elem.getElementsByTagName("resource");
        ArrayList<Element> toRemove = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            URI resource;
            Element n = (Element)nodes.item(i);
            String value = n.getAttribute("uri");
            try {
                resource = baseURI.resolve(value);
            }
            catch (IllegalArgumentException e) {
                this.getLog().error((CharSequence)("Malformed URL when creating the resource absolute URI : " + e.getMessage()));
                return null;
            }
            if (!"file".equals(resource.getScheme()) || new File(resource).exists()) continue;
            this.getLog().info((CharSequence)("The bundle " + n.getAttribute("presentationname") + " - " + n.getAttribute("version") + " will be removed"));
            toRemove.add(n);
        }
        Date d = new Date();
        if (toRemove.size() > 0) {
            for (int i = 0; i < toRemove.size(); ++i) {
                elem.removeChild((Node)toRemove.get(i));
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
            d.setTime(System.currentTimeMillis());
            elem.setAttribute("lastmodified", format.format(d));
            return elem;
        }
        return null;
    }

    private DocumentBuilder initConstructor() throws MojoExecutionException {
        DocumentBuilder constructor = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            constructor = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.getLog().error((CharSequence)"Unable to create a new xml document");
            throw new MojoExecutionException("Cannot create the Document Builder : " + e.getMessage());
        }
        return constructor;
    }

    private Document parseFile(File file, DocumentBuilder constructor) throws MojoExecutionException {
        if (constructor == null) {
            return null;
        }
        File targetFile = file.getAbsoluteFile();
        this.getLog().info((CharSequence)("Parsing " + targetFile));
        Document doc = null;
        try {
            doc = constructor.parse(targetFile);
        }
        catch (SAXException e) {
            this.getLog().error((CharSequence)("Cannot parse " + targetFile + " : " + e.getMessage()));
            throw new MojoExecutionException("Cannot parse " + targetFile + " : " + e.getMessage());
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Cannot open " + targetFile + " : " + e.getMessage()));
            throw new MojoExecutionException("Cannot open " + targetFile + " : " + e.getMessage());
        }
        return doc;
    }

    private void writeToFile(URI outputFilename, Node treeToBeWrite) throws MojoExecutionException {
        Transformer transformer = null;
        TransformerFactory tfabrique = TransformerFactory.newInstance();
        try {
            transformer = tfabrique.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            this.getLog().error((CharSequence)("Unable to write to file: " + outputFilename.toString()));
            throw new MojoExecutionException("Unable to write to file: " + outputFilename.toString() + " : " + e.getMessage());
        }
        Properties proprietes = new Properties();
        proprietes.put("method", "xml");
        proprietes.put("version", "1.0");
        proprietes.put("encoding", "ISO-8859-1");
        proprietes.put("standalone", "yes");
        proprietes.put("indent", "yes");
        proprietes.put("omit-xml-declaration", "no");
        transformer.setOutputProperties(proprietes);
        DOMSource input = new DOMSource(treeToBeWrite);
        File fichier = null;
        FileOutputStream flux = null;
        try {
            fichier = File.createTempFile("repository", ".xml");
            flux = new FileOutputStream(fichier);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Unable to write to file: " + fichier.getName()));
            throw new MojoExecutionException("Unable to write to file: " + fichier.getName() + " : " + e.getMessage());
        }
        StreamResult output = new StreamResult(flux);
        try {
            transformer.transform(input, output);
        }
        catch (TransformerException e) {
            throw new MojoExecutionException("Unable to write to file: " + outputFilename.toString() + " : " + e.getMessage());
        }
        try {
            flux.flush();
            flux.close();
            FileUtils.rename((File)fichier, (File)new File(outputFilename));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException when closing file : " + e.getMessage());
        }
    }
}

