/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obrplugin;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.felix.obrplugin.AbstractFileMojo;
import org.apache.felix.obrplugin.Config;
import org.apache.felix.obrplugin.ObrUpdate;
import org.apache.felix.obrplugin.ObrUtils;
import org.apache.felix.obrplugin.RemoteFileManager;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

@Mojo(name="deploy-file", requiresProject=false)
@Execute(phase=LifecyclePhase.DEPLOY)
public final class ObrDeployFile
extends AbstractFileMojo {
    @Parameter(property="ignoreLock")
    private boolean ignoreLock;
    @Parameter(property="remoteOBR")
    private String remoteOBR;
    @Parameter(property="obrRepository")
    private String obrRepository;
    @Parameter
    private List supportedProjectTypes = Arrays.asList("jar", "bundle");
    @Parameter(property="repositoryId", defaultValue="remote-repository", required=true)
    private String repositoryId;
    @Parameter(property="url", required=true)
    private String url;
    @Parameter(property="bundleUrl")
    private String bundleUrl;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Component
    private WagonManager m_wagonManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        MavenProject project = this.getProject();
        String projectType = project.getPackaging();
        if (!this.supportedProjectTypes.contains(projectType)) {
            this.getLog().warn((CharSequence)("Ignoring project type " + projectType + " - supportedProjectTypes = " + this.supportedProjectTypes));
            return;
        }
        if ("NONE".equalsIgnoreCase(this.remoteOBR) || "false".equalsIgnoreCase(this.remoteOBR)) {
            this.getLog().info((CharSequence)"Remote OBR update disabled (enable with -DremoteOBR)");
            return;
        }
        if (null == this.remoteOBR || this.remoteOBR.trim().length() == 0 || "true".equalsIgnoreCase(this.remoteOBR)) {
            this.remoteOBR = this.obrRepository;
        }
        URI tempURI = ObrUtils.findRepositoryXml("", this.remoteOBR);
        String repositoryName = new File(tempURI.getSchemeSpecificPart()).getName();
        Log log = this.getLog();
        RemoteFileManager remoteFile = new RemoteFileManager(this.m_wagonManager, this.settings, log);
        remoteFile.connect(this.repositoryId, this.url);
        log.info((CharSequence)("LOCK " + remoteFile + '/' + repositoryName));
        remoteFile.lockFile(repositoryName, this.ignoreLock);
        File downloadedRepositoryXml = null;
        try {
            log.info((CharSequence)("Downloading " + repositoryName));
            downloadedRepositoryXml = remoteFile.get(repositoryName, ".xml");
            String mavenRepository = this.localRepository.getBasedir();
            URI repositoryXml = downloadedRepositoryXml.toURI();
            URI obrXmlFile = ObrUtils.toFileURI(this.obrXml);
            URI bundleJar = null == this.file ? ObrUtils.getArtifactURI(this.localRepository, project.getArtifact()) : this.file.toURI();
            Config userConfig = new Config();
            userConfig.setRemoteFile(true);
            if (null != this.bundleUrl) {
                URI uri = URI.create(this.bundleUrl);
                log.info((CharSequence)("Computed bundle uri: " + uri));
                userConfig.setRemoteBundle(uri);
            } else if (null != this.file) {
                URI uri = URI.create(this.localRepository.pathOf(project.getArtifact()));
                log.info((CharSequence)("Computed bundle uri: " + uri));
                userConfig.setRemoteBundle(uri);
            }
            ObrUpdate update = new ObrUpdate(repositoryXml, obrXmlFile, project, mavenRepository, userConfig, log);
            update.parseRepositoryXml();
            update.updateRepository(bundleJar, null, null);
            update.writeRepositoryXml();
            if (downloadedRepositoryXml.exists()) {
                log.info((CharSequence)("Uploading " + repositoryName));
                remoteFile.put(downloadedRepositoryXml, repositoryName);
            }
        }
        catch (Exception e) {
            log.warn((CharSequence)("Exception while updating remote OBR: " + e.getLocalizedMessage()), (Throwable)e);
        }
        finally {
            log.info((CharSequence)("UNLOCK " + remoteFile + '/' + repositoryName));
            remoteFile.unlockFile(repositoryName);
            remoteFile.disconnect();
            if (null != downloadedRepositoryXml) {
                downloadedRepositoryXml.delete();
            }
        }
    }
}

