/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;

public abstract class UserClass
implements Serializable {
    public static final AllUsers ALL_USERS = new AllUsers();
    public static final ThisEntry THIS_ENTRY = new ThisEntry();
    public static final ParentOfEntry PARENT_OF_ENTRY = new ParentOfEntry();

    protected UserClass() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Subtree
    extends UserClass {
        private static final long serialVersionUID = 3949337699049701332L;
        protected final Collection<SubtreeSpecification> subtreeSpecifications;

        public Subtree(Collection<SubtreeSpecification> subtreeSpecs) {
            this.subtreeSpecifications = Collections.unmodifiableCollection(new ArrayList<SubtreeSpecification>(subtreeSpecs));
        }

        public Collection<SubtreeSpecification> getSubtreeSpecifications() {
            return this.subtreeSpecifications;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Subtree) {
                Subtree that = (Subtree)o;
                return ((Object)this.subtreeSpecifications).equals(that.subtreeSpecifications);
            }
            return false;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            boolean isFirst = true;
            buffer.append("subtree { ");
            for (SubtreeSpecification ss : this.subtreeSpecifications) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buffer.append(", ");
                }
                ss.printToBuffer(buffer);
            }
            buffer.append(" }");
            return buffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UserGroup
    extends NamedUserClass {
        private static final long serialVersionUID = 8887107815072965807L;

        public UserGroup(Set<DN> groupNames) {
            super(groupNames);
        }

        @Override
        public String toString() {
            return "userGroup " + super.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Name
    extends NamedUserClass {
        private static final long serialVersionUID = -4168412030168359882L;

        public Name(Set<DN> usernames) {
            super(usernames);
        }

        @Override
        public String toString() {
            return "name " + super.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class NamedUserClass
    extends UserClass {
        protected final Set<DN> names;

        protected NamedUserClass(Set<DN> names) {
            this.names = Collections.unmodifiableSet(new HashSet<DN>(names));
        }

        public Set<DN> getNames() {
            return this.names;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass().isAssignableFrom(o.getClass())) {
                Name that = (Name)o;
                return ((Object)this.names).equals(that.names);
            }
            return false;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            boolean isFirst = true;
            buffer.append("{ ");
            for (DN name : this.names) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append('\"');
                buffer.append(((Object)name).toString());
                buffer.append('\"');
            }
            buffer.append(" }");
            return buffer.toString();
        }
    }

    public static class ParentOfEntry
    extends UserClass {
        private static final long serialVersionUID = 5247207736068086476L;

        private ParentOfEntry() {
        }

        public String toString() {
            return "parentOfEntry";
        }
    }

    public static class ThisEntry
    extends UserClass {
        private static final long serialVersionUID = -8189325270233754470L;

        private ThisEntry() {
        }

        public String toString() {
            return "thisEntry";
        }
    }

    public static class AllUsers
    extends UserClass {
        private static final long serialVersionUID = 8967984720792510292L;

        private AllUsers() {
        }

        public String toString() {
            return "allUsers";
        }
    }
}

