/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.shared.ldap.codec.util.LdapURL;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.Referral;
import org.apache.directory.shared.ldap.message.ReferralImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.SearchRequest;
import org.apache.directory.shared.ldap.message.SearchResponseDone;
import org.apache.directory.shared.ldap.message.SearchResponseEntryImpl;
import org.apache.directory.shared.ldap.message.SearchResponseReferenceImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SearchResponseIterator
implements Iterator {
    private static final Logger log = LoggerFactory.getLogger((Class)SearchResponseIterator.class);
    private final SearchRequest req;
    private final ServerLdapContext ctx;
    private final NamingEnumeration underlying;
    private final IoSession session;
    private SearchResponseDone respDone;
    private boolean done;
    private Object prefetched;
    private final int scope;
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public SearchResponseIterator(SearchRequest req, ServerLdapContext ctx, NamingEnumeration underlying, int scope, IoSession session) {
        block13: {
            this.done = false;
            this.req = req;
            this.ctx = ctx;
            this.scope = scope;
            this.underlying = underlying;
            this.session = session;
            try {
                if (underlying.hasMore()) {
                    SearchResult result = (SearchResult)underlying.next();
                    Attribute ref = result.getAttributes().get("ref");
                    if (!ctx.isReferral(result.getName()) || req.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
                        SearchResponseEntryImpl respEntry = new SearchResponseEntryImpl(req.getMessageId());
                        respEntry.setAttributes(result.getAttributes());
                        try {
                            respEntry.setObjectName(new LdapDN(result.getName()));
                        }
                        catch (InvalidNameException ine) {
                            log.error("Invalid object name : " + result.getName(), (Throwable)ine);
                            throw new RuntimeException(ine);
                        }
                        this.prefetched = respEntry;
                        break block13;
                    }
                    SearchResponseReferenceImpl respRef = new SearchResponseReferenceImpl(req.getMessageId());
                    respRef.setReferral((Referral)new ReferralImpl());
                    for (int ii = 0; ii < ref.size(); ++ii) {
                        try {
                            String url = (String)ref.get(ii);
                            respRef.getReferral().addLdapUrl(url);
                            continue;
                        }
                        catch (NamingException e) {
                            try {
                                underlying.close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            this.prefetched = null;
                            this.respDone = this.getResponse(req, e);
                        }
                    }
                    this.prefetched = respRef;
                    break block13;
                }
                SessionRegistry.getSingleton().removeOutstandingRequest(session, req.getMessageId());
            }
            catch (NamingException e) {
                try {
                    this.underlying.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                this.respDone = this.getResponse(req, e);
            }
        }
    }

    public boolean hasNext() {
        return !this.done;
    }

    public Object next() {
        Object next = this.prefetched;
        SearchResult result = null;
        if (this.done) {
            throw new NoSuchElementException();
        }
        if (this.respDone != null) {
            this.done = true;
            return this.respDone;
        }
        try {
            if (!this.underlying.hasMore()) {
                try {
                    this.underlying.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                this.respDone = (SearchResponseDone)this.req.getResultResponse();
                this.respDone.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
                this.prefetched = null;
                SessionRegistry.getSingleton().removeOutstandingRequest(this.session, this.req.getMessageId());
                return next;
            }
            result = (SearchResult)this.underlying.next();
        }
        catch (NamingException e) {
            try {
                this.underlying.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.prefetched = null;
            this.respDone = this.getResponse(this.req, e);
            return next;
        }
        Attribute ref = result.getAttributes().get("ref");
        boolean isReferral = false;
        try {
            isReferral = this.ctx.isReferral(result.getName());
        }
        catch (NamingException e) {
            log.error("failed to determine if " + result.getName() + " is a referral", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (isReferral && ref == null) {
            try {
                ref = this.ctx.getAttributes(result.getName(), new String[]{"ref"}).get("ref");
            }
            catch (NamingException e) {
                log.error("failed to lookup ref attribute for " + result.getName(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (!isReferral || this.req.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
            SearchResponseEntryImpl respEntry = new SearchResponseEntryImpl(this.req.getMessageId());
            respEntry.setAttributes(result.getAttributes());
            try {
                respEntry.setObjectName(new LdapDN(result.getName()));
            }
            catch (InvalidNameException ine) {
                log.error("Invalid object name : " + result.getName(), (Throwable)ine);
                throw new RuntimeException(ine);
            }
            this.prefetched = respEntry;
        } else {
            SearchResponseReferenceImpl respRef = new SearchResponseReferenceImpl(this.req.getMessageId());
            respRef.setReferral((Referral)new ReferralImpl());
            for (int ii = 0; ii < ref.size(); ++ii) {
                String val;
                try {
                    val = (String)ref.get(ii);
                }
                catch (NamingException e1) {
                    log.error("failed to access referral url.");
                    try {
                        this.underlying.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.prefetched = null;
                    this.respDone = this.getResponse(this.req, e1);
                    return next;
                }
                if (!val.startsWith("ldap")) {
                    respRef.getReferral().addLdapUrl(val);
                    continue;
                }
                LdapURL ldapUrl = new LdapURL();
                try {
                    ldapUrl.parse(val.toCharArray());
                }
                catch (LdapURLEncodingException e) {
                    log.error("Bad URL (" + val + ") for ref in " + result.getName() + ".  Reference will be ignored.");
                    try {
                        this.underlying.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.prefetched = null;
                    this.respDone = this.getResponse(this.req, (Exception)((Object)e));
                    return next;
                }
                StringBuffer buf = new StringBuffer();
                buf.append(ldapUrl.getScheme());
                buf.append(ldapUrl.getHost());
                if (ldapUrl.getPort() > 0) {
                    buf.append(":");
                    buf.append(ldapUrl.getPort());
                }
                buf.append("/");
                buf.append(ldapUrl.getDn());
                buf.append("??");
                switch (this.scope) {
                    case 2: {
                        buf.append("sub");
                        break;
                    }
                    case 1: {
                        buf.append("base");
                        break;
                    }
                    case 0: {
                        buf.append("base");
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown recognized search scope: " + this.scope);
                    }
                }
                respRef.getReferral().addLdapUrl(buf.toString());
            }
            this.prefetched = respRef;
        }
        return next;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    SearchResponseDone getResponse(SearchRequest req, Exception e) {
        NamingException ne;
        String msg = "failed on search operation";
        if (IS_DEBUG) {
            msg = msg + ":\n" + req + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
        }
        SearchResponseDone resp = (SearchResponseDone)req.getResultResponse();
        ResultCodeEnum code = null;
        code = e instanceof LdapException ? ((LdapException)e).getResultCode() : ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType());
        resp.getLdapResult().setResultCode(code);
        resp.getLdapResult().setErrorMessage(msg);
        if (e instanceof NamingException && (ne = (NamingException)e).getResolvedName() != null && (code == ResultCodeEnum.NOSUCHOBJECT || code == ResultCodeEnum.ALIASPROBLEM || code == ResultCodeEnum.INVALIDDNSYNTAX || code == ResultCodeEnum.ALIASDEREFERENCINGPROBLEM)) {
            resp.getLdapResult().setMatchedDn((LdapDN)ne.getResolvedName());
        }
        SessionRegistry.getSingleton().removeOutstandingRequest(this.session, req.getMessageId());
        return resp;
    }
}

