/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message.control;

import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.search.controls.ChangeType;
import org.apache.directory.shared.ldap.codec.search.controls.pSearch.PSearchControlCodec;
import org.apache.directory.shared.ldap.message.control.InternalAbstractControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentSearchControl
extends InternalAbstractControl {
    private static final long serialVersionUID = -2356861450876343999L;
    private static final Logger LOG = LoggerFactory.getLogger(PersistentSearchControl.class);
    public static final String CONTROL_OID = "2.16.840.1.113730.3.4.3";
    public static final int ALL_CHANGES = 15;
    private boolean changesOnly = true;
    private boolean returnECs = false;
    private int changeTypes = 15;

    public PersistentSearchControl() {
        this.setID(CONTROL_OID);
    }

    public void setChangesOnly(boolean changesOnly) {
        this.changesOnly = changesOnly;
    }

    public boolean isChangesOnly() {
        return this.changesOnly;
    }

    public void setReturnECs(boolean returnECs) {
        this.returnECs = returnECs;
    }

    public boolean isReturnECs() {
        return this.returnECs;
    }

    public void setChangeTypes(int changeTypes) {
        this.changeTypes = changeTypes;
    }

    public int getChangeTypes() {
        return this.changeTypes;
    }

    public boolean isNotificationEnabled(ChangeType changeType) {
        return (changeType.getValue() & this.changeTypes) > 0;
    }

    public void enableNotification(ChangeType changeType) {
        this.changeTypes |= changeType.getValue();
    }

    public byte[] getEncodedValue() {
        PSearchControlCodec psearchCtlCodec = new PSearchControlCodec();
        psearchCtlCodec.setChangesOnly(this.changesOnly);
        psearchCtlCodec.setChangeTypes(this.changeTypes);
        psearchCtlCodec.setReturnECs(this.returnECs);
        try {
            return psearchCtlCodec.encode(null).array();
        }
        catch (EncoderException e) {
            LOG.error("Failed to encode psearch control", e);
            throw new IllegalStateException("Failed to encode control with encoder.", e);
        }
    }
}

