/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.search.ConnectorFilter;
import org.apache.directory.shared.ldap.codec.search.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrFilter
extends ConnectorFilter {
    public OrFilter(int tlvId) {
        super(tlvId);
    }

    public OrFilter() {
    }

    public List<Filter> getOrFilter() {
        return this.filterSet;
    }

    @Override
    public int computeLength() {
        this.filtersLength = super.computeLength();
        return 1 + TLV.getNbBytes(this.filtersLength) + this.filtersLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)-95);
            buffer.put(TLV.getBytes(this.filtersLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        super.encode(buffer);
        return buffer;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('|').append(super.toString());
        return sb.toString();
    }
}

