/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.AttributeValueAssertion;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.directory.shared.ldap.codec.search.SearchRequestCodec;
import org.apache.directory.shared.ldap.entry.AbstractValue;
import org.apache.directory.shared.ldap.entry.client.ClientBinaryValue;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitAssertionValueFilterAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(InitAssertionValueFilterAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public InitAssertionValueFilterAction() {
        super("Initialize Assertion Value filter");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessageCodec ldapMessage = ldapMessageContainer.getLdapMessage();
        SearchRequestCodec searchRequest = ldapMessage.getSearchRequest();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        AbstractValue assertionValue = null;
        assertionValue = tlv.getLength() != 0 ? new ClientBinaryValue(tlv.getValue().getData()) : new ClientBinaryValue(StringTools.EMPTY_BYTES);
        AttributeValueAssertionFilter terminalFilter = (AttributeValueAssertionFilter)searchRequest.getTerminalFilter();
        AttributeValueAssertion assertion = terminalFilter.getAssertion();
        if (ldapMessageContainer.isBinary(assertion.getAttributeDesc())) {
            assertionValue = tlv.getLength() != 0 ? new ClientBinaryValue(tlv.getValue().getData()) : new ClientBinaryValue(StringTools.EMPTY_BYTES);
            assertion.setAssertionValue(assertionValue);
        } else {
            assertionValue = tlv.getLength() != 0 ? new ClientStringValue(StringTools.utf8ToString(tlv.getValue().getData())) : new ClientStringValue("");
            assertion.setAssertionValue(assertionValue);
        }
        searchRequest.unstackFilters(container);
        if (IS_DEBUG) {
            log.debug("Initialize Assertion Value filter");
        }
    }
}

