/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.MatchingRuleRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMatchingRuleRegistry
implements MatchingRuleRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMatchingRuleRegistry.class);
    private final Map<String, MatchingRule> byOidMatchingRule;
    private final OidRegistry oidRegistry;

    public DefaultMatchingRuleRegistry(OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
        this.byOidMatchingRule = new ConcurrentHashMap<String, MatchingRule>();
    }

    @Override
    public MatchingRule lookup(String id) throws NamingException {
        String oid = this.oidRegistry.getOid(id);
        MatchingRule matchingRule = this.byOidMatchingRule.get(oid);
        if (matchingRule != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("lookup with id '{}' of matchingRule: {}", (Object)oid, (Object)matchingRule);
            }
            return matchingRule;
        }
        String msg = "Unknown MatchingRule OID " + oid;
        LOG.error(msg);
        throw new NamingException(msg);
    }

    @Override
    public void register(MatchingRule matchingRule) throws NamingException {
        String[] names;
        String oid = matchingRule.getOid();
        if (this.byOidMatchingRule.containsKey(oid)) {
            String msg = "matchingRule w/ OID " + oid + " has already been registered!";
            LOG.warn(msg);
            throw new NamingException(msg);
        }
        for (String name : names = matchingRule.getNamesRef()) {
            this.oidRegistry.register(name, oid);
        }
        this.oidRegistry.register(oid, oid);
        this.byOidMatchingRule.put(oid, matchingRule);
        if (LOG.isDebugEnabled()) {
            LOG.debug("registed matchingRule: {}", matchingRule);
        }
    }

    @Override
    public boolean hasMatchingRule(String id) {
        try {
            String oid = this.oidRegistry.getOid(id);
            if (oid != null) {
                return this.byOidMatchingRule.containsKey(oid);
            }
            return false;
        }
        catch (NamingException e) {
            return false;
        }
    }

    @Override
    public String getSchemaName(String id) throws NamingException {
        String oid = this.oidRegistry.getOid(id);
        MatchingRule mr = this.byOidMatchingRule.get(oid);
        if (mr != null) {
            return mr.getSchema();
        }
        String msg = "OID " + oid + " not found in oid to " + "MatchingRule name map!";
        LOG.warn(msg);
        throw new NamingException(msg);
    }

    @Override
    public Iterator<MatchingRule> iterator() {
        return this.byOidMatchingRule.values().iterator();
    }

    @Override
    public void unregister(String numericOid) throws NamingException {
        if (!OID.isOID(numericOid)) {
            String msg = "OID " + numericOid + " is not a numeric OID";
            LOG.error(msg);
            throw new NamingException(msg);
        }
        this.byOidMatchingRule.remove(numericOid);
    }
}

