/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.shared.ldap.message.InternalUnbindRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnbindHandler
extends LdapRequestHandler<InternalUnbindRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(UnbindHandler.class);

    @Override
    public void handle(LdapSession session, InternalUnbindRequest unbindRequest) throws Exception {
        LOG.debug("Received: {}", unbindRequest);
        try {
            session.getCoreSession().unbind(unbindRequest);
            session.getIoSession().close(true);
            this.ldapServer.getLdapSessionManager().removeLdapSession(session.getIoSession());
        }
        catch (Throwable t) {
            LOG.error("failed to unbind session properly", t);
        }
    }
}

