/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.AbstractSchemaObject;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MutableSchemaObject;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;

class ObjectClassImpl
extends AbstractSchemaObject
implements MutableSchemaObject,
ObjectClass {
    private static final long serialVersionUID = 1L;
    private final ObjectClass[] EMPTY_OC_ARRAY = new ObjectClass[0];
    private final String[] EMPTY_STR_ARRAY = new String[0];
    private final AttributeType[] EMPTY_AT_ARRAY = new AttributeType[0];
    private final Registries registries;
    private ObjectClassTypeEnum objectClassType;
    private ObjectClass[] superClasses;
    private String[] mayListOids;
    private AttributeType[] mayList = this.EMPTY_AT_ARRAY;
    private boolean mayListReloaded;
    private String[] mustListOids;
    private AttributeType[] mustList = this.EMPTY_AT_ARRAY;
    private boolean mustListReloaded;
    private String[] superClassOids;

    protected ObjectClassImpl(String oid, Registries registries) {
        super(oid);
        this.registries = registries;
    }

    public void setDescription(String description) {
        super.setDescription(description);
    }

    public void setNames(String[] names) {
        super.setNames(names);
    }

    public void setObsolete(boolean obsolete) {
        super.setObsolete(obsolete);
    }

    public void setSchema(String schema) {
        super.setSchema(schema);
    }

    public AttributeType[] getMayList() throws NamingException {
        if (this.mayListOids == null) {
            return this.EMPTY_AT_ARRAY;
        }
        if (this.mayListReloaded) {
            for (int ii = 0; ii < this.mayListOids.length; ++ii) {
                this.mayList[ii] = this.registries.getAttributeTypeRegistry().lookup(this.mayListOids[ii]);
            }
            this.mayListReloaded = false;
        }
        return this.mayList;
    }

    public void setMayListOids(String[] mayListOids) throws NamingException {
        if (mayListOids == null) {
            this.mayListOids = this.EMPTY_STR_ARRAY;
            this.mayList = this.EMPTY_AT_ARRAY;
        } else {
            this.mayListOids = mayListOids;
            this.mayList = new AttributeType[mayListOids.length];
        }
        this.mayListReloaded = true;
    }

    public AttributeType[] getMustList() throws NamingException {
        if (this.mustListOids == null) {
            return this.EMPTY_AT_ARRAY;
        }
        if (this.mustListReloaded) {
            for (int ii = 0; ii < this.mustListOids.length; ++ii) {
                this.mustList[ii] = this.registries.getAttributeTypeRegistry().lookup(this.mustListOids[ii]);
            }
            this.mustListReloaded = false;
        }
        return this.mustList;
    }

    public void setMustListOids(String[] mustListOids) throws NamingException {
        if (mustListOids == null) {
            this.mustListOids = this.EMPTY_STR_ARRAY;
            this.mustList = this.EMPTY_AT_ARRAY;
        } else {
            this.mustListOids = mustListOids;
            this.mustList = new AttributeType[mustListOids.length];
        }
        this.mustListReloaded = true;
    }

    public ObjectClass[] getSuperClasses() throws NamingException {
        if (this.superClassOids == null) {
            return this.EMPTY_OC_ARRAY;
        }
        for (int ii = 0; ii < this.superClassOids.length; ++ii) {
            this.superClasses[ii] = this.registries.getObjectClassRegistry().lookup(this.superClassOids[ii]);
        }
        return this.superClasses;
    }

    void setSuperClassOids(String[] superClassOids) {
        if (superClassOids == null || superClassOids.length == 0) {
            this.superClassOids = this.EMPTY_STR_ARRAY;
            this.superClasses = this.EMPTY_OC_ARRAY;
        } else {
            this.superClassOids = superClassOids;
            this.superClasses = new ObjectClass[superClassOids.length];
        }
    }

    public ObjectClassTypeEnum getType() {
        return this.objectClassType;
    }

    public boolean isStructural() {
        return this.objectClassType == ObjectClassTypeEnum.STRUCTURAL;
    }

    public boolean isAbstract() {
        return this.objectClassType == ObjectClassTypeEnum.ABSTRACT;
    }

    public boolean isAuxiliary() {
        return this.objectClassType == ObjectClassTypeEnum.AUXILIARY;
    }

    void setType(ObjectClassTypeEnum objectClassType) {
        this.objectClassType = objectClassType;
    }
}

