/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.text.ParseException;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.server.core.schema.AttributeTypeImpl;
import org.apache.directory.server.core.schema.DitContentRuleImpl;
import org.apache.directory.server.core.schema.DitStructureRuleImpl;
import org.apache.directory.server.core.schema.MatchingRuleImpl;
import org.apache.directory.server.core.schema.MatchingRuleUseImpl;
import org.apache.directory.server.core.schema.NameFormImpl;
import org.apache.directory.server.core.schema.ObjectClassImpl;
import org.apache.directory.server.core.schema.SchemaPartitionDao;
import org.apache.directory.server.core.schema.SyntaxImpl;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.schema.MutableSchemaObject;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.parsers.AbstractSchemaDescription;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescription;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.ComparatorDescription;
import org.apache.directory.shared.ldap.schema.parsers.ComparatorDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.DITContentRuleDescription;
import org.apache.directory.shared.ldap.schema.parsers.DITContentRuleDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.DITStructureRuleDescription;
import org.apache.directory.shared.ldap.schema.parsers.DITStructureRuleDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.LdapSyntaxDescription;
import org.apache.directory.shared.ldap.schema.parsers.LdapSyntaxDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.MatchingRuleDescription;
import org.apache.directory.shared.ldap.schema.parsers.MatchingRuleDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.MatchingRuleUseDescription;
import org.apache.directory.shared.ldap.schema.parsers.MatchingRuleUseDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.NameFormDescription;
import org.apache.directory.shared.ldap.schema.parsers.NameFormDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.NormalizerDescription;
import org.apache.directory.shared.ldap.schema.parsers.NormalizerDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassDescription;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.SyntaxCheckerDescription;
import org.apache.directory.shared.ldap.schema.parsers.SyntaxCheckerDescriptionSchemaParser;

public class DescriptionParsers {
    private static final String OTHER_SCHEMA = "other";
    private static final String[] EMPTY = new String[0];
    private static final Integer[] EMPTY_INT_ARRAY = new Integer[0];
    private static final ComparatorDescription[] EMPTY_COMPARATORS = new ComparatorDescription[0];
    private static final NormalizerDescription[] EMPTY_NORMALIZERS = new NormalizerDescription[0];
    private static final SyntaxCheckerDescription[] EMPTY_SYNTAX_CHECKERS = new SyntaxCheckerDescription[0];
    private static final Syntax[] EMPTY_SYNTAXES = new Syntax[0];
    private static final MatchingRule[] EMPTY_MATCHING_RULES = new MatchingRule[0];
    private static final AttributeType[] EMPTY_ATTRIBUTE_TYPES = new AttributeType[0];
    private static final ObjectClass[] EMPTY_OBJECT_CLASSES = new ObjectClass[0];
    private static final MatchingRuleUse[] EMPTY_MATCHING_RULE_USES = new MatchingRuleUse[0];
    private static final DITStructureRule[] EMPTY_DIT_STRUCTURE_RULES = new DITStructureRule[0];
    private static final DITContentRule[] EMPTY_DIT_CONTENT_RULES = new DITContentRule[0];
    private static final NameForm[] EMPTY_NAME_FORMS = new NameForm[0];
    private final Registries globalRegistries;
    private final ComparatorDescriptionSchemaParser comparatorParser = new ComparatorDescriptionSchemaParser();
    private final NormalizerDescriptionSchemaParser normalizerParser = new NormalizerDescriptionSchemaParser();
    private final SyntaxCheckerDescriptionSchemaParser syntaxCheckerParser = new SyntaxCheckerDescriptionSchemaParser();
    private final LdapSyntaxDescriptionSchemaParser syntaxParser = new LdapSyntaxDescriptionSchemaParser();
    private final MatchingRuleDescriptionSchemaParser matchingRuleParser = new MatchingRuleDescriptionSchemaParser();
    private final AttributeTypeDescriptionSchemaParser attributeTypeParser = new AttributeTypeDescriptionSchemaParser();
    private final ObjectClassDescriptionSchemaParser objectClassParser = new ObjectClassDescriptionSchemaParser();
    private final MatchingRuleUseDescriptionSchemaParser matchingRuleUseParser = new MatchingRuleUseDescriptionSchemaParser();
    private final DITStructureRuleDescriptionSchemaParser ditStructureRuleParser = new DITStructureRuleDescriptionSchemaParser();
    private final DITContentRuleDescriptionSchemaParser ditContentRuleParser = new DITContentRuleDescriptionSchemaParser();
    private final NameFormDescriptionSchemaParser nameFormParser = new NameFormDescriptionSchemaParser();
    private final SchemaPartitionDao dao;

    public DescriptionParsers(Registries globalRegistries, SchemaPartitionDao dao) {
        this.globalRegistries = globalRegistries;
        this.dao = dao;
    }

    public SyntaxCheckerDescription[] parseSyntaxCheckers(EntryAttribute attr) throws NamingException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_SYNTAX_CHECKERS;
        }
        SyntaxCheckerDescription[] syntaxCheckerDescriptions = new SyntaxCheckerDescription[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            try {
                syntaxCheckerDescriptions[pos++] = this.syntaxCheckerParser.parseSyntaxCheckerDescription(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException("The following does not conform to the syntaxCheckerDescription syntax: " + value, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
        }
        return syntaxCheckerDescriptions;
    }

    public NormalizerDescription[] parseNormalizers(EntryAttribute attr) throws NamingException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_NORMALIZERS;
        }
        NormalizerDescription[] normalizerDescriptions = new NormalizerDescription[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            try {
                normalizerDescriptions[pos++] = this.normalizerParser.parseNormalizerDescription(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException("The following does not conform to the normalizerDescription syntax: " + value.getString(), ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
        }
        return normalizerDescriptions;
    }

    public ComparatorDescription[] parseComparators(EntryAttribute attr) throws NamingException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_COMPARATORS;
        }
        ComparatorDescription[] comparatorDescriptions = new ComparatorDescription[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            try {
                comparatorDescriptions[pos++] = this.comparatorParser.parseComparatorDescription(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException("The following does not conform to the comparatorDescription syntax: " + value.getString(), ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
        }
        return comparatorDescriptions;
    }

    public AttributeType[] parseAttributeTypes(EntryAttribute attr) throws Exception {
        if (attr == null || attr.size() == 0) {
            return EMPTY_ATTRIBUTE_TYPES;
        }
        AttributeType[] attributeTypes = new AttributeType[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            AttributeType superType;
            AttributeTypeDescription desc = null;
            try {
                desc = this.attributeTypeParser.parseAttributeTypeDescription(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException("The following does not conform to the attributeTypeDescription syntax: " + value.getString(), ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
            if (desc.getSuperType() != null && !this.dao.hasAttributeType(desc.getSuperType())) {
                throw new LdapOperationNotSupportedException("Cannot permit the addition of an attributeType with an invalid super type: " + desc.getSuperType(), ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            if (desc.getSyntax() != null && !this.dao.hasSyntax(desc.getSyntax())) {
                throw new LdapOperationNotSupportedException("Cannot permit the addition of an attributeType with an invalid syntax: " + desc.getSyntax(), ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            if (desc.getEqualityMatchingRule() != null && !this.dao.hasMatchingRule(desc.getEqualityMatchingRule())) {
                throw new LdapOperationNotSupportedException("Cannot permit the addition of an attributeType with an invalid EQUALITY matchingRule: " + desc.getEqualityMatchingRule(), ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            if (desc.getOrderingMatchingRule() != null && !this.dao.hasMatchingRule(desc.getOrderingMatchingRule())) {
                throw new LdapOperationNotSupportedException("Cannot permit the addition of an attributeType with an invalid ORDERING matchingRule: " + desc.getOrderingMatchingRule(), ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            if (desc.getSubstringsMatchingRule() != null && !this.dao.hasMatchingRule(desc.getSubstringsMatchingRule())) {
                throw new LdapOperationNotSupportedException("Cannot permit the addition of an attributeType with an invalid SUBSTRINGS matchingRule: " + desc.getSubstringsMatchingRule(), ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            if (desc.getEqualityMatchingRule() == null && desc.getSuperType() == null) {
                throw new LdapOperationNotSupportedException("Cannot permit the addition of an attributeType with an no EQUALITY matchingRule \nand no super type from which to derive an EQUALITY matchingRule.", ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            if (desc.getEqualityMatchingRule() == null && (superType = this.globalRegistries.getAttributeTypeRegistry().lookup(desc.getSuperType())).getEquality() == null) {
                throw new LdapOperationNotSupportedException("Cannot permit the addition of an attributeType with which cannot resolve an EQUALITY matchingRule from it's super type.", ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            if (desc.getSyntax() == null && desc.getSuperType() == null) {
                throw new LdapOperationNotSupportedException("Cannot permit the addition of an attributeType with an no syntax \nand no super type from which to derive a syntax.", ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            AttributeTypeImpl at = new AttributeTypeImpl(desc.getNumericOid(), this.globalRegistries);
            at.setCanUserModify(desc.isUserModifiable());
            at.setCollective(desc.isCollective());
            at.setEqualityOid(desc.getEqualityMatchingRule());
            at.setOrderingOid(desc.getOrderingMatchingRule());
            at.setSingleValue(desc.isSingleValued());
            at.setSubstrOid(desc.getSubstringsMatchingRule());
            at.setSuperiorOid(desc.getSuperType());
            at.setSyntaxOid(desc.getSyntax());
            at.setUsage(desc.getUsage());
            this.setSchemaObjectProperties(desc, at);
            attributeTypes[pos++] = at;
        }
        return attributeTypes;
    }

    public ObjectClass[] parseObjectClasses(EntryAttribute attr) throws Exception {
        if (attr == null || attr.size() == 0) {
            return EMPTY_OBJECT_CLASSES;
        }
        ObjectClass[] objectClasses = new ObjectClass[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            ObjectClassDescription desc = null;
            try {
                desc = this.objectClassParser.parseObjectClassDescription(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException("The following does not conform to the objectClassDescription syntax: " + value.getString(), ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
            if (desc.getSuperiorObjectClasses() != null && desc.getSuperiorObjectClasses().size() > 0) {
                for (String superior : desc.getSuperiorObjectClasses()) {
                    if (superior.equals("2.5.6.0") || superior.equalsIgnoreCase("top") || this.dao.hasObjectClass(superior)) continue;
                    throw new LdapOperationNotSupportedException("Cannot permit the addition of an objectClass with an invalid superior objectClass: " + superior, ResultCodeEnum.UNWILLING_TO_PERFORM);
                }
            }
            if (desc.getMayAttributeTypes() != null && desc.getMayAttributeTypes().size() > 0) {
                for (String mayAttr : desc.getMayAttributeTypes()) {
                    if (this.dao.hasAttributeType(mayAttr)) continue;
                    throw new LdapOperationNotSupportedException("Cannot permit the addition of an objectClass with an invalid attributeType in the mayList: " + mayAttr, ResultCodeEnum.UNWILLING_TO_PERFORM);
                }
            }
            if (desc.getMustAttributeTypes() != null && desc.getMustAttributeTypes().size() > 0) {
                for (String mustAttr : desc.getMustAttributeTypes()) {
                    if (this.dao.hasAttributeType(mustAttr)) continue;
                    throw new LdapOperationNotSupportedException("Cannot permit the addition of an objectClass with an invalid attributeType in the mustList: " + mustAttr, ResultCodeEnum.UNWILLING_TO_PERFORM);
                }
            }
            ObjectClassImpl oc = new ObjectClassImpl(desc.getNumericOid(), this.globalRegistries);
            oc.setMayListOids(desc.getMayAttributeTypes().toArray(EMPTY));
            oc.setMustListOids(desc.getMustAttributeTypes().toArray(EMPTY));
            oc.setSuperClassOids(desc.getSuperiorObjectClasses().toArray(EMPTY));
            oc.setType(desc.getKind());
            this.setSchemaObjectProperties(desc, oc);
            objectClasses[pos++] = oc;
        }
        return objectClasses;
    }

    public MatchingRuleUse[] parseMatchingRuleUses(EntryAttribute attr) throws NamingException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_MATCHING_RULE_USES;
        }
        MatchingRuleUse[] matchingRuleUses = new MatchingRuleUse[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            MatchingRuleUseDescription desc = null;
            try {
                desc = this.matchingRuleUseParser.parseMatchingRuleUseDescription(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException("The following does not conform to the matchingRuleUseDescription syntax: " + value.getString(), ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
            MatchingRuleUseImpl mru = new MatchingRuleUseImpl(desc.getNumericOid(), this.globalRegistries);
            mru.setApplicableAttributesOids(desc.getApplicableAttributes().toArray(EMPTY));
            this.setSchemaObjectProperties(desc, mru);
            matchingRuleUses[pos++] = mru;
        }
        return matchingRuleUses;
    }

    public Syntax[] parseSyntaxes(EntryAttribute attr) throws Exception {
        if (attr == null || attr.size() == 0) {
            return EMPTY_SYNTAXES;
        }
        Syntax[] syntaxes = new Syntax[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            LdapSyntaxDescription desc = null;
            try {
                desc = this.syntaxParser.parseLdapSyntaxDescription(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException("The following does not conform to the ldapSyntaxDescription syntax: " + value.getString(), ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
            if (!this.dao.hasSyntaxChecker(desc.getNumericOid())) {
                throw new LdapOperationNotSupportedException("Cannot permit the addition of a syntax without the prior creation of a \nsyntaxChecker with the same object identifier of the syntax!", ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            SyntaxImpl syntax = new SyntaxImpl(desc.getNumericOid(), this.globalRegistries.getSyntaxCheckerRegistry());
            this.setSchemaObjectProperties(desc, syntax);
            syntax.setHumanReadable(this.isHumanReadable(desc));
            syntaxes[pos++] = syntax;
        }
        return syntaxes;
    }

    public MatchingRule[] parseMatchingRules(EntryAttribute attr) throws Exception {
        if (attr == null || attr.size() == 0) {
            return EMPTY_MATCHING_RULES;
        }
        MatchingRule[] matchingRules = new MatchingRule[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            MatchingRuleDescription desc = null;
            try {
                desc = this.matchingRuleParser.parseMatchingRuleDescription(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException("The following does not conform to the matchingRuleDescription syntax: " + value.getString(), ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
            if (!this.dao.hasSyntax(desc.getSyntax())) {
                throw new LdapOperationNotSupportedException("Cannot create a matchingRule that depends on non-existant syntax: " + desc.getSyntax(), ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            MatchingRuleImpl mr = new MatchingRuleImpl(desc.getNumericOid(), desc.getSyntax(), this.globalRegistries);
            this.setSchemaObjectProperties(desc, mr);
            matchingRules[pos++] = mr;
        }
        return matchingRules;
    }

    public DITStructureRule[] parseDitStructureRules(EntryAttribute attr) throws NamingException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_DIT_STRUCTURE_RULES;
        }
        DITStructureRule[] ditStructureRules = new DITStructureRule[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            DITStructureRuleDescription desc = null;
            try {
                desc = this.ditStructureRuleParser.parseDITStructureRuleDescription(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException("The following does not conform to the ditStructureRuleDescription syntax: " + value.getString(), ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
            DitStructureRuleImpl dsr = new DitStructureRuleImpl(desc.getNumericOid(), desc.getRuleId(), this.globalRegistries);
            dsr.setSuperClassRuleIds(desc.getSuperRules().toArray(EMPTY_INT_ARRAY));
            this.setSchemaObjectProperties(desc, dsr);
            ditStructureRules[pos++] = dsr;
        }
        return ditStructureRules;
    }

    public DITContentRule[] parseDitContentRules(EntryAttribute attr) throws NamingException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_DIT_CONTENT_RULES;
        }
        DITContentRule[] ditContentRules = new DITContentRule[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            DITContentRuleDescription desc = null;
            try {
                desc = this.ditContentRuleParser.parseDITContentRuleDescription(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException("The following does not conform to the ditContentRuleDescription syntax: " + value.getString(), ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
            DitContentRuleImpl dcr = new DitContentRuleImpl(desc.getNumericOid(), this.globalRegistries);
            dcr.setAuxObjectClassOids(desc.getAuxiliaryObjectClasses().toArray(EMPTY));
            dcr.setMayNameOids(desc.getMayAttributeTypes().toArray(EMPTY));
            dcr.setMustNameOids(desc.getMustAttributeTypes().toArray(EMPTY));
            dcr.setNotNameOids(desc.getNotAttributeTypes().toArray(EMPTY));
            this.setSchemaObjectProperties(desc, dcr);
            ditContentRules[pos++] = dcr;
        }
        return ditContentRules;
    }

    public NameForm[] parseNameForms(EntryAttribute attr) throws NamingException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_NAME_FORMS;
        }
        NameForm[] nameForms = new NameForm[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            NameFormDescription desc = null;
            try {
                desc = this.nameFormParser.parseNameFormDescription(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException("The following does not conform to the nameFormDescription syntax: " + value.getString(), ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
            NameFormImpl nf = new NameFormImpl(desc.getNumericOid(), this.globalRegistries);
            nf.setMayUseOids(desc.getMayAttributeTypes().toArray(EMPTY));
            nf.setMustUseOids(desc.getMustAttributeTypes().toArray(EMPTY));
            nf.setObjectClassOid(desc.getStructuralObjectClass());
            this.setSchemaObjectProperties(desc, nf);
            nameForms[pos++] = nf;
        }
        return nameForms;
    }

    private void setSchemaObjectProperties(AbstractSchemaDescription desc, MutableSchemaObject obj) {
        obj.setDescription(desc.getDescription());
        obj.setSchema(this.getSchema(desc));
        if (!(desc instanceof LdapSyntaxDescription)) {
            obj.setNames(desc.getNames().toArray(EMPTY));
            obj.setObsolete(desc.isObsolete());
        }
    }

    private boolean isHumanReadable(LdapSyntaxDescription desc) {
        List<String> values = desc.getExtensions().get("X-IS-HUMAN-READABLE");
        if (values == null || values.size() == 0) {
            return false;
        }
        String value = values.get(0);
        return value.equals("TRUE");
    }

    private String getSchema(AbstractSchemaDescription desc) {
        List<String> values = desc.getExtensions().get("X-SCHEMA");
        if (values == null) {
            return OTHER_SCHEMA;
        }
        return values.get(0);
    }
}

