/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.AnonymousAuthenticator;
import org.apache.directory.server.core.authn.Authenticator;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.authn.SimpleAuthenticator;
import org.apache.directory.server.core.authn.StrongAuthenticator;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.GetSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.ListSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.exception.LdapAuthenticationException;
import org.apache.directory.shared.ldap.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationInterceptor.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private Set<Authenticator> authenticators;
    private final Map<String, Collection<Authenticator>> authenticatorsMapByType = new HashMap<String, Collection<Authenticator>>();
    private DirectoryService directoryService;

    @Override
    public void init(DirectoryService directoryService) throws Exception {
        this.directoryService = directoryService;
        if (this.authenticators == null) {
            this.setDefaultAuthenticators();
        }
        for (Authenticator authenticator : this.authenticators) {
            this.register(authenticator, directoryService);
        }
    }

    private void setDefaultAuthenticators() {
        HashSet<Authenticator> set = new HashSet<Authenticator>();
        set.add(new AnonymousAuthenticator());
        set.add(new SimpleAuthenticator());
        set.add(new StrongAuthenticator());
        this.setAuthenticators(set);
    }

    public Set<Authenticator> getAuthenticators() {
        return this.authenticators;
    }

    public void setAuthenticators(Set<Authenticator> authenticators) {
        this.authenticators = authenticators;
    }

    @Override
    public void destroy() {
        this.authenticatorsMapByType.clear();
        HashSet<Authenticator> copy = new HashSet<Authenticator>(this.authenticators);
        this.authenticators = null;
        for (Authenticator authenticator : copy) {
            authenticator.destroy();
        }
    }

    private void register(Authenticator authenticator, DirectoryService directoryService) throws Exception {
        authenticator.init(directoryService);
        Collection<Authenticator> authenticatorList = this.getAuthenticators(authenticator.getAuthenticatorType());
        if (authenticatorList == null) {
            authenticatorList = new ArrayList<Authenticator>();
            this.authenticatorsMapByType.put(authenticator.getAuthenticatorType(), authenticatorList);
        }
        authenticatorList.add(authenticator);
    }

    private Collection<Authenticator> getAuthenticators(String type) {
        Collection<Authenticator> result = this.authenticatorsMapByType.get(type);
        if (result != null && result.size() > 0) {
            return result;
        }
        return null;
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext opContext) throws Exception {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", opContext);
        }
        this.checkAuthenticated(opContext);
        next.add(opContext);
    }

    @Override
    public void delete(NextInterceptor next, DeleteOperationContext opContext) throws Exception {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", opContext);
        }
        this.checkAuthenticated(opContext);
        next.delete(opContext);
        this.invalidateAuthenticatorCaches(opContext.getDn());
    }

    @Override
    public LdapDN getMatchedName(NextInterceptor next, GetMatchedNameOperationContext opContext) throws Exception {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", opContext);
        }
        this.checkAuthenticated(opContext);
        return next.getMatchedName(opContext);
    }

    @Override
    public ClonedServerEntry getRootDSE(NextInterceptor next, GetRootDSEOperationContext opContext) throws Exception {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", opContext);
        }
        this.checkAuthenticated(opContext);
        return next.getRootDSE(opContext);
    }

    @Override
    public LdapDN getSuffix(NextInterceptor next, GetSuffixOperationContext opContext) throws Exception {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", opContext);
        }
        this.checkAuthenticated(opContext);
        return next.getSuffix(opContext);
    }

    @Override
    public boolean hasEntry(NextInterceptor next, EntryOperationContext opContext) throws Exception {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", opContext);
        }
        this.checkAuthenticated(opContext);
        return next.hasEntry(opContext);
    }

    @Override
    public EntryFilteringCursor list(NextInterceptor next, ListOperationContext opContext) throws Exception {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", opContext);
        }
        this.checkAuthenticated(opContext);
        return next.list(opContext);
    }

    @Override
    public Set<String> listSuffixes(NextInterceptor next, ListSuffixOperationContext opContext) throws Exception {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", opContext);
        }
        this.checkAuthenticated(opContext);
        return next.listSuffixes(opContext);
    }

    @Override
    public ClonedServerEntry lookup(NextInterceptor next, LookupOperationContext opContext) throws Exception {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", opContext);
        }
        this.checkAuthenticated(opContext);
        return next.lookup(opContext);
    }

    private void invalidateAuthenticatorCaches(LdapDN principalDn) {
        for (String authMech : this.authenticatorsMapByType.keySet()) {
            Collection<Authenticator> authenticators = this.getAuthenticators(authMech);
            for (Authenticator authenticator : authenticators) {
                authenticator.invalidateCache(principalDn);
            }
        }
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws Exception {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", opContext);
        }
        this.checkAuthenticated(opContext);
        next.modify(opContext);
        this.invalidateAuthenticatorCaches(opContext.getDn());
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext opContext) throws Exception {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", opContext);
        }
        this.checkAuthenticated(opContext);
        next.rename(opContext);
        this.invalidateAuthenticatorCaches(opContext.getDn());
    }

    @Override
    public boolean compare(NextInterceptor next, CompareOperationContext opContext) throws Exception {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", opContext);
        }
        this.checkAuthenticated(opContext);
        boolean result = next.compare(opContext);
        this.invalidateAuthenticatorCaches(opContext.getDn());
        return result;
    }

    @Override
    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext opContext) throws Exception {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", opContext);
        }
        this.checkAuthenticated(opContext);
        next.moveAndRename(opContext);
        this.invalidateAuthenticatorCaches(opContext.getDn());
    }

    @Override
    public void move(NextInterceptor next, MoveOperationContext opContext) throws Exception {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", opContext);
        }
        this.checkAuthenticated(opContext);
        next.move(opContext);
        this.invalidateAuthenticatorCaches(opContext.getDn());
    }

    @Override
    public EntryFilteringCursor search(NextInterceptor next, SearchOperationContext opContext) throws Exception {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", opContext);
        }
        this.checkAuthenticated(opContext);
        return next.search(opContext);
    }

    private void checkAuthenticated(OperationContext operation) throws Exception {
        if (operation.getSession().isAnonymous() && !this.directoryService.isAllowAnonymousAccess() && !operation.getDn().isEmpty()) {
            LOG.error("Attempted operation {} by unauthenticated caller.", (Object)operation.getName());
            throw new LdapNoPermissionException("Attempted operation by unauthenticated caller.");
        }
    }

    @Override
    public void bind(NextInterceptor next, BindOperationContext opContext) throws Exception {
        LdapDN dn;
        AuthenticationLevel level;
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", opContext);
        }
        if (opContext.getSession() != null && opContext.getSession().getEffectivePrincipal() != null) {
            opContext.setCredentials(null);
        }
        if ((level = opContext.getAuthenticationLevel()) == AuthenticationLevel.UNAUTHENT) {
            throw new LdapOperationNotSupportedException("Cannot Bind for DN " + opContext.getDn().getUpName(), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        Collection<Authenticator> authenticators = this.getAuthenticators(level.getName());
        if (authenticators == null) {
            LOG.debug("No authenticators found, delegating bind to the nexus.");
            next.bind(opContext);
            LOG.debug("Nexus succeeded on bind operation.");
            LdapPrincipal principal = new LdapPrincipal(opContext.getDn(), AuthenticationLevel.SIMPLE);
            DefaultCoreSession session = new DefaultCoreSession(principal, this.directoryService);
            opContext.setSession(session);
            opContext.setCredentials(null);
            return;
        }
        for (Authenticator authenticator : authenticators) {
            try {
                LdapPrincipal principal = authenticator.authenticate(opContext);
                LdapPrincipal clonedPrincipal = (LdapPrincipal)principal.clone();
                opContext.setCredentials(null);
                clonedPrincipal.setUserPassword(StringTools.EMPTY_BYTES);
                DefaultCoreSession session = new DefaultCoreSession(clonedPrincipal, this.directoryService);
                opContext.setSession(session);
                return;
            }
            catch (LdapAuthenticationException e) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info("Authenticator {} failed to authenticate: {}", authenticator, (Object)opContext);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.info("Unexpected failure for Authenticator {} : {}", authenticator, (Object)opContext);
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Cannot bind to the server ");
        }
        String upDn = (dn = opContext.getDn()) == null ? "" : dn.getUpName();
        throw new LdapAuthenticationException("Cannot authenticate user " + upDn);
    }
}

