/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.naming.NamingException;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DefaultOperationManager;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.OperationManager;
import org.apache.directory.server.core.ReferralManager;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.authz.AciAuthorizationInterceptor;
import org.apache.directory.server.core.authz.DefaultAuthorizationInterceptor;
import org.apache.directory.server.core.changelog.ChangeLog;
import org.apache.directory.server.core.changelog.ChangeLogEvent;
import org.apache.directory.server.core.changelog.ChangeLogInterceptor;
import org.apache.directory.server.core.changelog.DefaultChangeLog;
import org.apache.directory.server.core.changelog.Tag;
import org.apache.directory.server.core.changelog.TaggableSearchableChangeLogStore;
import org.apache.directory.server.core.collective.CollectiveAttributeInterceptor;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.event.EventInterceptor;
import org.apache.directory.server.core.event.EventService;
import org.apache.directory.server.core.exception.ExceptionInterceptor;
import org.apache.directory.server.core.interceptor.Interceptor;
import org.apache.directory.server.core.interceptor.InterceptorChain;
import org.apache.directory.server.core.interceptor.context.AddContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.RemoveContextPartitionOperationContext;
import org.apache.directory.server.core.journal.DefaultJournal;
import org.apache.directory.server.core.journal.Journal;
import org.apache.directory.server.core.journal.JournalInterceptor;
import org.apache.directory.server.core.normalization.NormalizationInterceptor;
import org.apache.directory.server.core.operational.OperationalAttributeInterceptor;
import org.apache.directory.server.core.partition.DefaultPartitionNexus;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.referral.ReferralInterceptor;
import org.apache.directory.server.core.replication.ReplicationConfiguration;
import org.apache.directory.server.core.schema.PartitionSchemaLoader;
import org.apache.directory.server.core.schema.SchemaInterceptor;
import org.apache.directory.server.core.schema.SchemaOperationControl;
import org.apache.directory.server.core.schema.SchemaPartitionDao;
import org.apache.directory.server.core.schema.SchemaService;
import org.apache.directory.server.core.security.TlsKeyGenerator;
import org.apache.directory.server.core.subtree.SubentryInterceptor;
import org.apache.directory.server.core.trigger.TriggerInterceptor;
import org.apache.directory.server.schema.SerializableComparator;
import org.apache.directory.server.schema.bootstrap.ApacheSchema;
import org.apache.directory.server.schema.bootstrap.ApachemetaSchema;
import org.apache.directory.server.schema.bootstrap.BootstrapSchemaLoader;
import org.apache.directory.server.schema.bootstrap.CoreSchema;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.bootstrap.SystemSchema;
import org.apache.directory.server.schema.bootstrap.partition.DbFileListing;
import org.apache.directory.server.schema.bootstrap.partition.SchemaPartitionExtractor;
import org.apache.directory.server.schema.registries.DefaultOidRegistry;
import org.apache.directory.server.schema.registries.DefaultRegistries;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.csn.Csn;
import org.apache.directory.shared.ldap.csn.CsnFactory;
import org.apache.directory.shared.ldap.cursor.Cursor;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.DefaultClientEntry;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaUtils;
import org.apache.directory.shared.ldap.schema.normalizers.OidNormalizer;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.DateUtils;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDirectoryService
implements DirectoryService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDirectoryService.class);
    private static final String ILLEGAL_STATE_MSG = "Something has got to be severely wrong with the core packaging\nor the build to have resulted in this exception.";
    private SchemaService schemaService;
    private Registries registries;
    private DefaultPartitionNexus partitionNexus;
    private boolean firstStart;
    private InterceptorChain interceptorChain;
    private boolean started;
    private ChangeLog changeLog;
    private Journal journal;
    private OperationManager operationManager = new DefaultOperationManager(this);
    private LdapDN adminDn;
    private CoreSession adminSession;
    private ReferralManager referralManager;
    private boolean passwordHidden = false;
    private CsnFactory csnFactory;
    private int replicaId;
    private ReplicationConfiguration replicationConfig;
    private static final String PARTIAL_IMPL_WARNING = "WARNING: the changelog is only partially operational and will revert\nstate without consideration of who made the original change.  All reverting changes are made by the admin user.\n Furthermore the used controls are not at all taken into account";
    private long syncPeriodMillis;
    private static final long DEFAULT_SYNC_PERIOD = 15000L;
    private Thread workerThread;
    private SynchWorker worker = new SynchWorker();
    public static final int MAX_SIZE_LIMIT_DEFAULT = 100;
    public static final int MAX_TIME_LIMIT_DEFAULT = 10000;
    private String instanceId;
    private File workingDirectory = new File("server-work");
    private boolean exitVmOnShutdown = true;
    private boolean shutdownHookEnabled = true;
    private boolean allowAnonymousAccess = true;
    private boolean accessControlEnabled;
    private boolean denormalizeOpAttrsEnabled;
    private List<Interceptor> interceptors;
    private Partition systemPartition;
    private Set<Partition> partitions = new HashSet<Partition>();
    private List<? extends LdifEntry> testEntries = new ArrayList<LdifEntry>();
    private EventService eventService;
    private int maxPDUSize = Integer.MAX_VALUE;

    public DefaultDirectoryService() {
        this.setDefaultInterceptorConfigurations();
        this.changeLog = new DefaultChangeLog();
        this.journal = new DefaultJournal();
        this.syncPeriodMillis = 15000L;
        BootstrapSchemaLoader loader = new BootstrapSchemaLoader();
        DefaultOidRegistry oidRegistry = new DefaultOidRegistry();
        this.registries = new DefaultRegistries("bootstrap", loader, oidRegistry);
        HashSet<Schema> bootstrapSchemas = new HashSet<Schema>();
        bootstrapSchemas.add(new ApachemetaSchema());
        bootstrapSchemas.add(new ApacheSchema());
        bootstrapSchemas.add(new CoreSchema());
        bootstrapSchemas.add(new SystemSchema());
        try {
            loader.loadWithDependencies(bootstrapSchemas, this.registries);
        }
        catch (Exception e) {
            throw new IllegalStateException(ILLEGAL_STATE_MSG, e);
        }
        List<Throwable> errors = this.registries.checkRefInteg();
        if (!errors.isEmpty()) {
            NamingException e = new NamingException();
            e.setRootCause(errors.get(0));
            throw new IllegalStateException(ILLEGAL_STATE_MSG, e);
        }
        SerializableComparator.setRegistry(this.registries.getComparatorRegistry());
        this.csnFactory = new CsnFactory(this.replicaId);
    }

    @Override
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public Set<? extends Partition> getPartitions() {
        HashSet<Partition> cloned = new HashSet<Partition>();
        cloned.addAll(this.partitions);
        return cloned;
    }

    @Override
    public void setPartitions(Set<? extends Partition> partitions) {
        HashSet<Partition> cloned = new HashSet<Partition>();
        cloned.addAll(partitions);
        HashSet<String> names = new HashSet<String>();
        for (Partition partition : cloned) {
            String id = partition.getId();
            if (names.contains(id)) {
                LOG.warn("Encountered duplicate partition {} identifier.", (Object)id);
            }
            names.add(id);
        }
        this.partitions = cloned;
    }

    @Override
    public boolean isAccessControlEnabled() {
        return this.accessControlEnabled;
    }

    @Override
    public void setAccessControlEnabled(boolean accessControlEnabled) {
        this.accessControlEnabled = accessControlEnabled;
    }

    @Override
    public boolean isAllowAnonymousAccess() {
        return this.allowAnonymousAccess;
    }

    @Override
    public void setAllowAnonymousAccess(boolean enableAnonymousAccess) {
        this.allowAnonymousAccess = enableAnonymousAccess;
    }

    @Override
    public List<Interceptor> getInterceptors() {
        ArrayList<Interceptor> cloned = new ArrayList<Interceptor>();
        cloned.addAll(this.interceptors);
        return cloned;
    }

    @Override
    public void setInterceptors(List<Interceptor> interceptors) {
        HashSet<String> names = new HashSet<String>();
        for (Interceptor interceptor : interceptors) {
            String name = interceptor.getName();
            if (names.contains(name)) {
                LOG.warn("Encountered duplicate definitions for {} interceptor", (Object)interceptor.getName());
            }
            names.add(name);
        }
        this.interceptors = interceptors;
    }

    @Override
    public List<LdifEntry> getTestEntries() {
        ArrayList<LdifEntry> cloned = new ArrayList<LdifEntry>();
        cloned.addAll(this.testEntries);
        return cloned;
    }

    @Override
    public void setTestEntries(List<? extends LdifEntry> testEntries) {
        ArrayList<? extends LdifEntry> cloned = new ArrayList<LdifEntry>();
        cloned.addAll(testEntries);
        this.testEntries = testEntries;
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Override
    public void setShutdownHookEnabled(boolean shutdownHookEnabled) {
        this.shutdownHookEnabled = shutdownHookEnabled;
    }

    @Override
    public boolean isShutdownHookEnabled() {
        return this.shutdownHookEnabled;
    }

    @Override
    public void setExitVmOnShutdown(boolean exitVmOnShutdown) {
        this.exitVmOnShutdown = exitVmOnShutdown;
    }

    @Override
    public boolean isExitVmOnShutdown() {
        return this.exitVmOnShutdown;
    }

    @Override
    public void setSystemPartition(Partition systemPartition) {
        this.systemPartition = systemPartition;
    }

    @Override
    public Partition getSystemPartition() {
        return this.systemPartition;
    }

    @Override
    public boolean isDenormalizeOpAttrsEnabled() {
        return this.denormalizeOpAttrsEnabled;
    }

    @Override
    public void setDenormalizeOpAttrsEnabled(boolean denormalizeOpAttrsEnabled) {
        this.denormalizeOpAttrsEnabled = denormalizeOpAttrsEnabled;
    }

    @Override
    public ChangeLog getChangeLog() {
        return this.changeLog;
    }

    @Override
    public Journal getJournal() {
        return this.journal;
    }

    @Override
    public void setChangeLog(ChangeLog changeLog) {
        this.changeLog = changeLog;
    }

    @Override
    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    @Override
    public void addPartition(Partition parition) throws Exception {
        this.partitions.add(parition);
        if (!this.started) {
            return;
        }
        AddContextPartitionOperationContext addPartitionCtx = new AddContextPartitionOperationContext(this.adminSession, parition);
        this.partitionNexus.addContextPartition(addPartitionCtx);
    }

    @Override
    public void removePartition(Partition partition) throws Exception {
        this.partitions.remove(partition);
        if (!this.started) {
            return;
        }
        RemoveContextPartitionOperationContext removePartitionCtx = new RemoveContextPartitionOperationContext(this.adminSession, partition.getSuffixDn());
        this.partitionNexus.removeContextPartition(removePartitionCtx);
    }

    private void setDefaultInterceptorConfigurations() {
        ArrayList<Interceptor> list = new ArrayList<Interceptor>();
        list.add(new NormalizationInterceptor());
        list.add(new AuthenticationInterceptor());
        list.add(new ReferralInterceptor());
        list.add(new AciAuthorizationInterceptor());
        list.add(new DefaultAuthorizationInterceptor());
        list.add(new ExceptionInterceptor());
        list.add(new ChangeLogInterceptor());
        list.add(new OperationalAttributeInterceptor());
        list.add(new SchemaInterceptor());
        list.add(new SubentryInterceptor());
        list.add(new CollectiveAttributeInterceptor());
        list.add(new EventInterceptor());
        list.add(new TriggerInterceptor());
        list.add(new JournalInterceptor());
        this.setInterceptors(list);
    }

    @Override
    public CoreSession getAdminSession() {
        return this.adminSession;
    }

    @Override
    public CoreSession getSession() {
        return new DefaultCoreSession(new LdapPrincipal(), this);
    }

    @Override
    public CoreSession getSession(LdapPrincipal principal) {
        return new DefaultCoreSession(principal, this);
    }

    @Override
    public CoreSession getSession(LdapDN principalDn, byte[] credentials) throws Exception {
        if (!this.started) {
            throw new IllegalStateException("Service has not started.");
        }
        BindOperationContext bindContext = new BindOperationContext(null);
        bindContext.setCredentials(credentials);
        bindContext.setDn(principalDn);
        this.operationManager.bind(bindContext);
        return bindContext.getSession();
    }

    @Override
    public CoreSession getSession(LdapDN principalDn, byte[] credentials, String saslMechanism, String saslAuthId) throws Exception {
        if (!this.started) {
            throw new IllegalStateException("Service has not started.");
        }
        BindOperationContext bindContext = new BindOperationContext(null);
        bindContext.setCredentials(credentials);
        bindContext.setDn(principalDn);
        bindContext.setSaslMechanism(saslMechanism);
        this.operationManager.bind(bindContext);
        return bindContext.getSession();
    }

    @Override
    public long revert() throws Exception {
        if (this.changeLog == null || !this.changeLog.isEnabled()) {
            throw new IllegalStateException("The change log must be enabled to revert to previous log revisions.");
        }
        Tag latest = this.changeLog.getLatest();
        if (null != latest) {
            if (latest.getRevision() < this.changeLog.getCurrentRevision()) {
                return this.revert(latest.getRevision());
            }
            LOG.info("Ignoring request to revert without changes since the latest tag.");
            return this.changeLog.getCurrentRevision();
        }
        throw new IllegalStateException("There must be at least one tag to revert to the latest tag.");
    }

    private void moddn(LdapDN oldDn, LdapDN newDn, boolean delOldRdn) throws Exception {
        if (oldDn.size() == 0) {
            throw new LdapNoPermissionException("can't rename the rootDSE");
        }
        LdapDN oldBase = (LdapDN)oldDn.clone();
        oldBase.remove(oldDn.size() - 1);
        LdapDN newBase = (LdapDN)newDn.clone();
        newBase.remove(newDn.size() - 1);
        Rdn newRdn = newDn.getRdn(newDn.size() - 1);
        Rdn oldRdn = oldDn.getRdn(oldDn.size() - 1);
        if (oldDn.size() == newDn.size() && oldBase.equals(newBase)) {
            this.adminSession.rename(oldDn, newRdn, delOldRdn);
        } else {
            LdapDN target = (LdapDN)newDn.clone();
            target.remove(newDn.size() - 1);
            if (newRdn.equals(oldRdn)) {
                this.adminSession.move(oldDn, target);
            } else {
                this.adminSession.moveAndRename(oldDn, target, new Rdn(newRdn), delOldRdn);
            }
        }
    }

    @Override
    public long revert(long revision) throws Exception {
        if (this.changeLog == null || !this.changeLog.isEnabled()) {
            throw new IllegalStateException("The change log must be enabled to revert to previous log revisions.");
        }
        if (revision < 0L) {
            throw new IllegalArgumentException("revision must be greater than or equal to 0");
        }
        if (revision >= this.changeLog.getChangeLogStore().getCurrentRevision()) {
            throw new IllegalArgumentException("revision must be less than the current revision");
        }
        Cursor<ChangeLogEvent> cursor = this.changeLog.getChangeLogStore().findAfter(revision);
        try {
            LOG.warn(PARTIAL_IMPL_WARNING);
            cursor.afterLast();
            while (cursor.previous()) {
                ChangeLogEvent event = cursor.get();
                List<LdifEntry> reverses = event.getReverseLdifs();
                block9: for (LdifEntry reverse : reverses) {
                    switch (reverse.getChangeType().getChangeType()) {
                        case 0: {
                            this.adminSession.add((ServerEntry)new DefaultServerEntry(this.registries, reverse.getEntry()), true);
                            continue block9;
                        }
                        case 4: {
                            this.adminSession.delete(reverse.getDn(), true);
                            continue block9;
                        }
                        case 1: {
                            List<Modification> mods = reverse.getModificationItems();
                            this.adminSession.modify(reverse.getDn(), mods, true);
                            continue block9;
                        }
                        case 2: 
                        case 3: {
                            LdapDN forwardDn = event.getForwardLdif().getDn();
                            LdapDN reverseDn = reverse.getDn();
                            this.moddn(reverseDn, forwardDn, reverse.isDeleteOldRdn());
                            continue block9;
                        }
                    }
                    LOG.error("ChangeType unknown");
                    throw new NotImplementedException("Reverts of change type " + (Object)((Object)reverse.getChangeType()) + " has not yet been implemented!");
                }
            }
        }
        catch (IOException e) {
            String message = "Encountered a failure while trying to revert to a previous revision: " + revision;
            LOG.error(message);
            throw new NamingException(message);
        }
        return this.changeLog.getCurrentRevision();
    }

    @Override
    public OperationManager getOperationManager() {
        return this.operationManager;
    }

    @Override
    public synchronized void startup() throws Exception {
        if (this.started) {
            return;
        }
        if (this.shutdownHookEnabled) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                public void run() {
                    try {
                        DefaultDirectoryService.this.shutdown();
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to shut down the directory service: " + DefaultDirectoryService.this.instanceId, e);
                    }
                }
            }, "ApacheDS Shutdown Hook (" + this.instanceId + ')'));
            LOG.info("ApacheDS shutdown hook has been registered with the runtime.");
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("ApacheDS shutdown hook has NOT been registered with the runtime.  This default setting for standalone operation has been overriden.");
        }
        this.initialize();
        this.showSecurityWarnings();
        if (this.syncPeriodMillis > 0L) {
            this.workerThread = new Thread((Runnable)this.worker, "SynchWorkerThread");
            this.workerThread.start();
        }
        this.started = true;
        if (!this.testEntries.isEmpty()) {
            this.createTestEntries();
        }
    }

    @Override
    public synchronized void sync() throws Exception {
        if (!this.started) {
            return;
        }
        this.changeLog.sync();
        this.partitionNexus.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() throws Exception {
        if (!this.started) {
            return;
        }
        this.changeLog.sync();
        this.changeLog.destroy();
        if (this.journal.isEnabled()) {
            this.journal.destroy();
        }
        this.partitionNexus.sync();
        this.partitionNexus.destroy();
        if (this.workerThread != null) {
            this.worker.stop = true;
            Object object = this.worker.lock;
            synchronized (object) {
                this.worker.lock.notify();
            }
            while (this.workerThread.isAlive()) {
                LOG.info("Waiting for SynchWorkerThread to die.");
                this.workerThread.join(500L);
            }
        }
        this.interceptorChain.destroy();
        this.started = false;
        this.setDefaultInterceptorConfigurations();
    }

    @Override
    public ReferralManager getReferralManager() {
        return this.referralManager;
    }

    @Override
    public void setReferralManager(ReferralManager referralManager) {
        this.referralManager = referralManager;
    }

    @Override
    public Registries getRegistries() {
        return this.registries;
    }

    @Override
    public void setRegistries(Registries registries) {
        this.registries = registries;
    }

    @Override
    public SchemaService getSchemaService() {
        return this.schemaService;
    }

    @Override
    public void setSchemaService(SchemaService schemaService) {
        this.schemaService = schemaService;
    }

    @Override
    public PartitionNexus getPartitionNexus() {
        return this.partitionNexus;
    }

    @Override
    public InterceptorChain getInterceptorChain() {
        return this.interceptorChain;
    }

    public boolean isFirstStart() {
        return this.firstStart;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public ServerEntry newEntry(LdapDN dn) {
        return new DefaultServerEntry(this.registries, dn);
    }

    private boolean createBootstrapEntries() throws Exception {
        boolean firstStart = false;
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(this.adminSession, PartitionNexus.getAdminName()))) {
            firstStart = true;
            DefaultServerEntry serverEntry = new DefaultServerEntry(this.registries, PartitionNexus.getAdminName());
            serverEntry.put("objectClass", "top", "person", "organizationalPerson", "inetOrgPerson");
            serverEntry.put("uid", "admin");
            serverEntry.put("userPassword", (byte[][])new byte[][]{PartitionNexus.ADMIN_PASSWORD_BYTES});
            serverEntry.put("displayName", "Directory Superuser");
            serverEntry.put("cn", "system administrator");
            serverEntry.put("sn", "administrator");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.put("displayName", "Directory Superuser");
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", (byte[][])new byte[][]{SchemaUtils.uuidToBytes(UUID.randomUUID())});
            TlsKeyGenerator.addKeyPair(serverEntry);
            this.partitionNexus.add(new AddOperationContext(this.adminSession, serverEntry));
        }
        Map<String, OidNormalizer> oidsMap = this.registries.getAttributeTypeRegistry().getNormalizerMapping();
        LdapDN userDn = new LdapDN("ou=users,ou=system");
        userDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(this.adminSession, userDn))) {
            firstStart = true;
            DefaultServerEntry serverEntry = new DefaultServerEntry(this.registries, userDn);
            serverEntry.put("objectClass", "top", "organizationalUnit");
            serverEntry.put("ou", "users");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", (byte[][])new byte[][]{SchemaUtils.uuidToBytes(UUID.randomUUID())});
            this.partitionNexus.add(new AddOperationContext(this.adminSession, serverEntry));
        }
        LdapDN groupDn = new LdapDN("ou=groups,ou=system");
        groupDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(this.adminSession, groupDn))) {
            firstStart = true;
            DefaultServerEntry serverEntry = new DefaultServerEntry(this.registries, groupDn);
            serverEntry.put("objectClass", "top", "organizationalUnit");
            serverEntry.put("ou", "groups");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", (byte[][])new byte[][]{SchemaUtils.uuidToBytes(UUID.randomUUID())});
            this.partitionNexus.add(new AddOperationContext(this.adminSession, serverEntry));
        }
        LdapDN name = new LdapDN("cn=Administrators,ou=groups,ou=system");
        name.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(this.adminSession, name))) {
            firstStart = true;
            DefaultServerEntry serverEntry = new DefaultServerEntry(this.registries, name);
            serverEntry.put("objectClass", "top", "groupOfUniqueNames");
            serverEntry.put("cn", "Administrators");
            serverEntry.put("uniqueMember", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", (byte[][])new byte[][]{SchemaUtils.uuidToBytes(UUID.randomUUID())});
            this.partitionNexus.add(new AddOperationContext(this.adminSession, serverEntry));
        }
        LdapDN configurationDn = new LdapDN("ou=configuration,ou=system");
        configurationDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(this.adminSession, configurationDn))) {
            firstStart = true;
            DefaultServerEntry serverEntry = new DefaultServerEntry(this.registries, configurationDn);
            serverEntry.put("objectClass", "top", "organizationalUnit");
            serverEntry.put("ou", "configuration");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", (byte[][])new byte[][]{SchemaUtils.uuidToBytes(UUID.randomUUID())});
            this.partitionNexus.add(new AddOperationContext(this.adminSession, serverEntry));
        }
        LdapDN partitionsDn = new LdapDN("ou=partitions,ou=configuration,ou=system");
        partitionsDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(this.adminSession, partitionsDn))) {
            firstStart = true;
            DefaultServerEntry serverEntry = new DefaultServerEntry(this.registries, partitionsDn);
            serverEntry.put("objectClass", "top", "organizationalUnit");
            serverEntry.put("ou", "partitions");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", (byte[][])new byte[][]{SchemaUtils.uuidToBytes(UUID.randomUUID())});
            this.partitionNexus.add(new AddOperationContext(this.adminSession, serverEntry));
        }
        LdapDN servicesDn = new LdapDN("ou=services,ou=configuration,ou=system");
        servicesDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(this.adminSession, servicesDn))) {
            firstStart = true;
            DefaultServerEntry serverEntry = new DefaultServerEntry(this.registries, servicesDn);
            serverEntry.put("objectClass", "top", "organizationalUnit");
            serverEntry.put("ou", "services");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", (byte[][])new byte[][]{SchemaUtils.uuidToBytes(UUID.randomUUID())});
            this.partitionNexus.add(new AddOperationContext(this.adminSession, serverEntry));
        }
        LdapDN interceptorsDn = new LdapDN("ou=interceptors,ou=configuration,ou=system");
        interceptorsDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(this.adminSession, interceptorsDn))) {
            firstStart = true;
            DefaultServerEntry serverEntry = new DefaultServerEntry(this.registries, interceptorsDn);
            serverEntry.put("objectClass", "top", "organizationalUnit");
            serverEntry.put("ou", "interceptors");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", (byte[][])new byte[][]{SchemaUtils.uuidToBytes(UUID.randomUUID())});
            this.partitionNexus.add(new AddOperationContext(this.adminSession, serverEntry));
        }
        LdapDN sysPrefRootDn = new LdapDN("prefNodeName=sysPrefRoot,ou=system");
        sysPrefRootDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(this.adminSession, sysPrefRootDn))) {
            firstStart = true;
            DefaultServerEntry serverEntry = new DefaultServerEntry(this.registries, sysPrefRootDn);
            serverEntry.put("objectClass", "top", "organizationalUnit", "extensibleObject");
            serverEntry.put("prefNodeName", "sysPrefRoot");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", (byte[][])new byte[][]{SchemaUtils.uuidToBytes(UUID.randomUUID())});
            this.partitionNexus.add(new AddOperationContext(this.adminSession, serverEntry));
        }
        return firstStart;
    }

    private void showSecurityWarnings() throws Exception {
        boolean needToChangeAdminPassword = false;
        LdapDN adminDn = new LdapDN("uid=admin,ou=system");
        adminDn.normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
        ClonedServerEntry adminEntry = this.partitionNexus.lookup(new LookupOperationContext(this.adminSession, adminDn));
        Value<?> userPassword = adminEntry.get("userPassword").get();
        if (userPassword instanceof byte[]) {
            needToChangeAdminPassword = Arrays.equals(PartitionNexus.ADMIN_PASSWORD_BYTES, (byte[])userPassword);
        } else if (userPassword.toString().equals("secret")) {
            needToChangeAdminPassword = "secret".equals(userPassword.toString());
        }
        if (needToChangeAdminPassword) {
            LOG.warn("You didn't change the admin password of directory service instance '" + this.instanceId + "'.  " + "Please update the admin password as soon as possible " + "to prevent a possible security breach.");
        }
    }

    private void createTestEntries() throws Exception {
        for (LdifEntry ldifEntry : this.testEntries) {
            try {
                LdifEntry ldifEntry2 = ldifEntry.clone();
                Entry entry = ldifEntry2.getEntry();
                String dn = ldifEntry2.getDn().getUpName();
                try {
                    this.getAdminSession().add(new DefaultServerEntry(this.registries, entry));
                }
                catch (Exception e) {
                    LOG.warn(dn + " test entry already exists.", e);
                }
            }
            catch (CloneNotSupportedException cnse) {
                LOG.warn("Cannot clone the entry ", cnse);
            }
        }
    }

    private void initialize() throws Exception {
        DbFileListing listing;
        File schemaDirectory;
        if (LOG.isDebugEnabled()) {
            LOG.debug("---> Initializing the DefaultDirectoryService ");
        }
        if (!(schemaDirectory = new File(this.workingDirectory, "schema")).exists()) {
            try {
                SchemaPartitionExtractor extractor = new SchemaPartitionExtractor(this.workingDirectory);
                extractor.extract();
            }
            catch (IOException e) {
                NamingException ne = new NamingException("Failed to extract pre-loaded schema partition.");
                ne.setRootCause(e);
                throw ne;
            }
        }
        JdbmPartition schemaPartition = new JdbmPartition();
        schemaPartition.setId("schema");
        schemaPartition.setCacheSize(1000);
        try {
            listing = new DbFileListing();
        }
        catch (IOException e) {
            throw new LdapNamingException("Got IOException while trying to read DBFileListing: " + e.getMessage(), ResultCodeEnum.OTHER);
        }
        HashSet indexedAttributes = new HashSet();
        for (String attributeId : listing.getIndexedAttributes()) {
            indexedAttributes.add(new JdbmIndex(attributeId));
        }
        schemaPartition.setIndexedAttributes(indexedAttributes);
        schemaPartition.setSuffix("ou=schema");
        schemaPartition.init(this);
        SchemaPartitionDao dao = new SchemaPartitionDao(schemaPartition, this.registries);
        Map<String, Schema> schemaMap = dao.getSchemas();
        HashSet<Partition> partitions = new HashSet<Partition>();
        partitions.add(this.systemPartition);
        partitions.addAll(this.partitions);
        for (Partition partition : partitions) {
            if (!(partition instanceof BTreePartition)) continue;
            JdbmPartition btpconf = (JdbmPartition)partition;
            for (Index<?, ServerEntry> index : btpconf.getIndexedAttributes()) {
                String schemaName = null;
                try {
                    AttributeType at = this.registries.getAttributeTypeRegistry().lookup(index.getAttributeId());
                    schemaName = dao.findSchema(at.getOid());
                }
                catch (Exception e) {
                    schemaName = dao.findSchema(index.getAttributeId());
                }
                if (schemaName == null) {
                    throw new NamingException("Index on unidentified attribute: " + index.toString());
                }
                Schema schema = schemaMap.get(schemaName);
                if (!schema.isDisabled()) continue;
                dao.enableSchema(schemaName);
            }
        }
        PartitionSchemaLoader schemaLoader = new PartitionSchemaLoader(schemaPartition, this.registries);
        DefaultRegistries globalRegistries = new DefaultRegistries("global", schemaLoader, this.registries.getOidRegistry());
        schemaLoader.loadEnabled(globalRegistries);
        this.registries = globalRegistries;
        SerializableComparator.setRegistry(globalRegistries.getComparatorRegistry());
        SchemaOperationControl schemaControl = new SchemaOperationControl(this.registries, schemaLoader, new SchemaPartitionDao(schemaPartition, this.registries));
        this.schemaService = new SchemaService(this, schemaPartition, schemaControl);
        this.adminDn = new LdapDN("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
        this.adminDn.normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
        this.adminSession = new DefaultCoreSession(new LdapPrincipal(this.adminDn, AuthenticationLevel.STRONG), this);
        this.partitionNexus = new DefaultPartitionNexus(new DefaultServerEntry(this.registries, LdapDN.EMPTY_LDAPDN));
        this.partitionNexus.init(this);
        this.partitionNexus.addContextPartition(new AddContextPartitionOperationContext(this.adminSession, schemaPartition));
        this.firstStart = this.createBootstrapEntries();
        this.interceptorChain = new InterceptorChain();
        this.interceptorChain.init(this);
        if (this.changeLog.isEnabled()) {
            this.changeLog.init(this);
            if (this.changeLog.isExposed() && this.changeLog.isTagSearchSupported()) {
                String clSuffix = ((TaggableSearchableChangeLogStore)this.changeLog.getChangeLogStore()).getPartition().getSuffix();
                this.partitionNexus.getRootDSE(null).getOriginalEntry().add("changeLogContext", clSuffix);
            }
        }
        if (this.journal.isEnabled()) {
            this.journal.init(this);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<--- DefaultDirectoryService initialized");
        }
    }

    private Entry readEntry(String text) {
        StringReader strIn = new StringReader(text);
        BufferedReader in = new BufferedReader(strIn);
        String line = null;
        DefaultClientEntry entry = new DefaultClientEntry();
        block6: while (true) {
            try {
                while ((line = in.readLine()) != null) {
                    String addedLine;
                    if (line.length() == 0 || StringTools.isEmpty(addedLine = line.trim())) continue;
                    EntryAttribute attribute = AttributeUtils.toClientAttribute(LdifReader.parseAttributeValue(addedLine));
                    EntryAttribute oldAttribute = entry.get(attribute.getId());
                    if (oldAttribute != null) {
                        try {
                            oldAttribute.add(attribute.get());
                            entry.put(oldAttribute);
                            continue block6;
                        }
                        catch (NamingException ne) {
                            continue;
                        }
                    }
                    try {
                        entry.put(attribute);
                        continue block6;
                    }
                    catch (NamingException ne) {
                    }
                }
                break;
            }
            catch (IOException ioe) {
                // empty catch block
                break;
            }
        }
        return entry;
    }

    @Override
    public ServerEntry newEntry(String ldif, String dn) {
        try {
            Entry entry = this.readEntry(ldif);
            LdapDN ldapDn = new LdapDN(dn);
            entry.setDn(ldapDn);
            DefaultServerEntry serverEntry = new DefaultServerEntry(this.registries, entry);
            return serverEntry;
        }
        catch (Exception e) {
            LOG.error("Cannot build an entry for '{}' and this DN :'{}'", (Object)ldif, (Object)dn);
            return null;
        }
    }

    @Override
    public EventService getEventService() {
        return this.eventService;
    }

    @Override
    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    @Override
    public boolean isPasswordHidden() {
        return this.passwordHidden;
    }

    @Override
    public void setPassordHidden(boolean passwordHidden) {
        this.passwordHidden = passwordHidden;
    }

    @Override
    public int getMaxPDUSize() {
        return this.maxPDUSize;
    }

    @Override
    public void setMaxPDUSize(int maxPDUSize) {
        if (maxPDUSize <= 0) {
            maxPDUSize = Integer.MAX_VALUE;
        }
        this.maxPDUSize = maxPDUSize;
    }

    @Override
    public Interceptor getInterceptor(String interceptorName) {
        for (Interceptor interceptor : this.interceptors) {
            if (!interceptor.getName().equalsIgnoreCase(interceptorName)) continue;
            return interceptor;
        }
        return null;
    }

    @Override
    public Csn getCSN() {
        return this.csnFactory.newInstance();
    }

    @Override
    public int getReplicaId() {
        return this.replicaId;
    }

    @Override
    public void setReplicaId(int replicaId) {
        if (replicaId < 0 || replicaId > 999) {
            LOG.error("The replicaId must be in [0, 999]");
            this.replicaId = 0;
        } else {
            this.replicaId = replicaId;
        }
    }

    @Override
    public void setReplicationConfiguration(ReplicationConfiguration replicationConfig) {
        this.replicationConfig = replicationConfig;
    }

    @Override
    public ReplicationConfiguration getReplicationConfiguration() {
        return this.replicationConfig;
    }

    public long getSyncPeriodMillis() {
        return this.syncPeriodMillis;
    }

    public void setSyncPeriodMillis(long syncPeriodMillis) {
        this.syncPeriodMillis = syncPeriodMillis;
    }

    class SynchWorker
    implements Runnable {
        final Object lock = new Object();
        boolean stop;

        SynchWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stop) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(DefaultDirectoryService.this.syncPeriodMillis);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("SynchWorker failed to wait on lock.", e);
                    }
                }
                try {
                    DefaultDirectoryService.this.partitionNexus.sync();
                }
                catch (Exception e) {
                    LOG.error("SynchWorker failed to synch directory.", e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LogChange {
        TRUE,
        FALSE;

    }
}

