/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import jdbm.recman.BlockIo;
import jdbm.recman.FreeLogicalRowIdPage;
import jdbm.recman.Location;
import jdbm.recman.PageCursor;
import jdbm.recman.PageManager;
import jdbm.recman.PhysicalRowId;
import jdbm.recman.RecordFile;

final class FreeLogicalRowIdPageManager {
    private RecordFile file;
    private PageManager pageman;

    FreeLogicalRowIdPageManager(RecordFile file, PageManager pageman) throws IOException {
        this.file = file;
        this.pageman = pageman;
    }

    Location get() throws IOException {
        Location retval = null;
        PageCursor curs = new PageCursor(this.pageman, 3);
        while (curs.next() != 0L) {
            FreeLogicalRowIdPage fp = FreeLogicalRowIdPage.getFreeLogicalRowIdPageView(this.file.get(curs.getCurrent()));
            int slot = fp.getFirstAllocated();
            if (slot != -1) {
                retval = new Location(fp.get(slot));
                fp.free(slot);
                if (fp.getCount() == 0) {
                    this.file.release(curs.getCurrent(), false);
                    this.pageman.free((short)3, curs.getCurrent());
                } else {
                    this.file.release(curs.getCurrent(), true);
                }
                return retval;
            }
            this.file.release(curs.getCurrent(), false);
        }
        return null;
    }

    void put(Location rowid) throws IOException {
        FreeLogicalRowIdPage fp;
        BlockIo curBlock;
        PhysicalRowId free = null;
        PageCursor curs = new PageCursor(this.pageman, 3);
        long freePage = 0L;
        while (curs.next() != 0L) {
            freePage = curs.getCurrent();
            curBlock = this.file.get(freePage);
            fp = FreeLogicalRowIdPage.getFreeLogicalRowIdPageView(curBlock);
            int slot = fp.getFirstFree();
            if (slot != -1) {
                free = fp.alloc(slot);
                break;
            }
            this.file.release(curBlock);
        }
        if (free == null) {
            freePage = this.pageman.allocate((short)3);
            curBlock = this.file.get(freePage);
            fp = FreeLogicalRowIdPage.getFreeLogicalRowIdPageView(curBlock);
            free = fp.alloc(0);
        }
        free.setBlock(rowid.getBlock());
        free.setOffset(rowid.getOffset());
        this.file.release(freePage, true);
    }
}

