/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api.message;

import org.apache.directory.ldap.client.api.message.AbandonableRequest;
import org.apache.directory.ldap.client.api.message.AbstractRequest;
import org.apache.directory.ldap.client.api.message.RequestWithResponse;
import org.apache.directory.shared.ldap.util.StringTools;

public class BindRequest
extends AbstractRequest
implements RequestWithResponse,
AbandonableRequest {
    private String name;
    private byte[] credentials;
    private String saslMechanism;
    private boolean isSimple = true;
    private int version = 3;

    public byte[] getCredentials() {
        return this.credentials;
    }

    public BindRequest setCredentials(byte[] credentials) {
        this.credentials = credentials;
        return this;
    }

    public BindRequest setCredentials(String credentials) {
        this.credentials = StringTools.getBytesUtf8((String)credentials);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public BindRequest setName(String name) {
        this.name = name;
        return this;
    }

    public String getSaslMechanism() {
        return this.saslMechanism;
    }

    public BindRequest setSaslMechanism(String saslMechanism) {
        this.saslMechanism = saslMechanism;
        return this;
    }

    public int getVersion() {
        return this.version;
    }

    public BindRequest setVersion(int version) {
        this.version = version;
        return this;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public boolean isVersion3() {
        return this.version == 3;
    }

    public BindRequest setSasl() {
        this.isSimple = false;
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("    BindRequest\n");
        sb.append("        Version : '").append(this.version).append("'\n");
        if (null == this.name || StringTools.isEmpty((String)this.name.toString())) {
            sb.append("        Name : anonymous\n");
        } else {
            sb.append("        Name : '").append(this.name).append("'\n");
            if (this.isSimple) {
                sb.append("        Simple authentication : '").append(StringTools.utf8ToString((byte[])this.credentials)).append("'\n");
            } else {
                sb.append("        Sasl authentication : \n");
                sb.append("            mechanism : '").append(this.saslMechanism).append("'\n");
                sb.append("            credentials : '").append(StringTools.utf8ToString((byte[])this.credentials)).append("'\n");
            }
        }
        return sb.toString();
    }
}

