/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api.future;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.directory.ldap.client.api.LdapConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseFuture<R>
implements Future<R> {
    protected BlockingQueue<R> queue = new LinkedBlockingQueue<R>();
    protected boolean cancelled = false;
    protected int messageId;
    protected LdapConnection connection;

    public ResponseFuture(LdapConnection connection, int messageId) {
        this.messageId = messageId;
        this.connection = connection;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.cancelled) {
            return this.cancelled;
        }
        this.cancelled = true;
        if (this.connection.doesFutureExistFor(this.messageId)) {
            this.connection.abandon(this.messageId);
        }
        this.queue.clear();
        return this.cancelled;
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        R response = null;
        response = this.queue.take();
        return response;
    }

    public synchronized void set(R response) throws InterruptedException, ExecutionException {
        this.queue.add(response);
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        R response = this.queue.poll(timeout, unit);
        return response;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[msgId : ").append(this.messageId).append(", ");
        sb.append("size : ").append(this.queue.size()).append(", ");
        sb.append("Canceled :").append(this.cancelled).append("]");
        return sb.toString();
    }
}

